/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipal;

class FileOwnership {
    private final UserPrincipal owner;
    private final GroupPrincipal group;

    public FileOwnership(UserPrincipal owner, GroupPrincipal group) {
        this.owner = owner;
        this.group = group;
    }

    public void applyTo(Path path) throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            FileOwnerAttributeView ownerView = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
            if (ownerView != null) {
                ownerView.setOwner(this.owner);
                System.out.println("Successfully set owner on Windows to: " + this.owner.getName());
            } else {
                System.err.println("Could not get FileOwnerAttributeView for " + path);
            }
        } else if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
            PosixFileAttributeView posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixView != null) {
                posixView.setOwner(this.owner);
                System.out.println("Successfully set owner to: " + this.owner.getName());
                if (this.group != null) {
                    posixView.setGroup(this.group);
                    System.out.println("Successfully set group to: " + this.group.getName());
                }
            } else {
                System.err.println("Could not get PosixFileAttributeView for " + path);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported OS for setting ownership: " + os);
        }
    }
}

