/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.command;

import com.sshtools.common.command.ExecutableCommand;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SessionChannel;
import com.sshtools.common.ssh.SessionChannelServer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractExecutableCommand
implements ExecutableCommand {
    protected SessionChannelServer session;

    @Override
    public void init(SessionChannelServer session) {
        this.session = session;
        session.haltIncomingData();
    }

    @Override
    public SessionChannel getSession() {
        return this.session;
    }

    @Override
    public abstract boolean createProcess(String[] var1, Map<String, String> var2);

    @Override
    public void start() {
        this.session.getConnection().executeTask(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractExecutableCommand.this.onStart();
                }
                catch (Throwable e) {
                    Log.error((String)"Consumed error from executable command", (Throwable)e, (Object[])new Object[0]);
                }
            }
        });
    }

    @Override
    public abstract void onStart();

    @Override
    public abstract void kill();

    @Override
    public abstract int getExitCode();

    @Override
    public OutputStream getOutputStream() {
        return this.session.getOutputStream();
    }

    @Override
    public OutputStream getStderrOutputStream() {
        return this.session.getErrorStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.session.getInputStream();
    }

    @Override
    public boolean allocatePseudoTerminal(String term, int cols, int rows, int width, int height, byte[] modes) {
        return false;
    }
}

