/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sshd.config;

import com.sshtools.common.sshd.config.CommentEntry;
import com.sshtools.common.sshd.config.MatchEntry;
import com.sshtools.common.sshd.config.SshdConfigFile;
import com.sshtools.common.sshd.config.SshdConfigFileEntry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.concurrent.Callable;

public class SshdConfigFileWriter {
    private OutputStream stream;
    private String newline = System.lineSeparator();

    public SshdConfigFileWriter(OutputStream stream) {
        this.stream = stream;
    }

    public SshdConfigFileWriter(OutputStream stream, String newline) {
        this.stream = stream;
        this.newline = newline;
    }

    public void write(final SshdConfigFile sshdConfigFile, boolean indentMatchEntries) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Stream not initiallized.");
        }
        if (sshdConfigFile == null) {
            throw new IllegalStateException("SshdConfigFile not initiallized.");
        }
        sshdConfigFile.executeRead(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(SshdConfigFileWriter.this.stream));){
                    boolean start = false;
                    block5: for (SshdConfigFileEntry keyEntry : sshdConfigFile.getGlobalConfiguration().getKeyEntries().values()) {
                        while (true) {
                            if (start) {
                                bw.write(SshdConfigFileWriter.this.newline);
                            }
                            start = true;
                            bw.write(keyEntry.getFormattedLine());
                            if (!keyEntry.hasNext()) continue block5;
                            keyEntry = keyEntry.getNext();
                        }
                    }
                    Iterator<MatchEntry> matchEntriesIterator = sshdConfigFile.getMatchEntriesIterator();
                    while (matchEntriesIterator.hasNext()) {
                        MatchEntry matchEntry = matchEntriesIterator.next();
                        if (matchEntry.matchEntryCriteriaAsString() == null || matchEntry.matchEntryCriteriaAsString().trim().length() == 0) {
                            throw new IllegalStateException("Match entry criteria string cannot be empty.");
                        }
                        Iterator<CommentEntry> commentEntryIterator = matchEntry.getMatchCriteriaCommentEntriesIterator();
                        while (commentEntryIterator.hasNext()) {
                            CommentEntry commentEntry = commentEntryIterator.next();
                            if (start) {
                                bw.write(SshdConfigFileWriter.this.newline);
                            }
                            bw.write(commentEntry.getFormattedLine());
                            start = true;
                        }
                        if (start) {
                            bw.write(SshdConfigFileWriter.this.newline);
                        }
                        bw.write(matchEntry.getFormattedLine());
                        start = true;
                        block9: for (SshdConfigFileEntry keyEntry : matchEntry.getKeyEntries().values()) {
                            while (true) {
                                if (start) {
                                    bw.write(SshdConfigFileWriter.this.newline);
                                }
                                bw.write(keyEntry.getFormattedLine());
                                if (!keyEntry.hasNext()) continue block9;
                                keyEntry = keyEntry.getNext();
                            }
                        }
                    }
                    bw.write(SshdConfigFileWriter.this.newline);
                }
                return null;
            }
        });
    }

    public synchronized void write(SshdConfigFile sshdConfigFile) throws IOException {
        this.write(sshdConfigFile, true);
    }
}

