/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshHmacFactory;
import com.sshtools.common.ssh.components.jce.AbstractHmac;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacRipeMd160ETM
extends AbstractHmac {
    private static final String ALGORITHM = "hmac-ripemd160-etm@openssh.com";

    public HmacRipeMd160ETM() {
        super("HmacRipeMd160", 20, SecurityLevel.WEAK, 2);
    }

    protected HmacRipeMd160ETM(int size) {
        super("HmacRipeMd160", 20, size, SecurityLevel.WEAK, 2);
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public boolean isETM() {
        return true;
    }

    @Override
    public void init(byte[] keydata) throws SshException {
        try {
            this.mac = JCEProvider.getProviderForAlgorithm(this.jceAlgorithm) == null ? Mac.getInstance(this.jceAlgorithm) : Mac.getInstance(this.jceAlgorithm, JCEProvider.getProviderForAlgorithm(this.jceAlgorithm));
            byte[] key = new byte[20];
            System.arraycopy(keydata, 0, key, 0, key.length);
            SecretKeySpec keyspec = new SecretKeySpec(key, this.jceAlgorithm);
            this.mac.init(keyspec);
        }
        catch (Throwable t) {
            throw new SshException(t);
        }
    }

    public static class HmacRipeMd160ETMFactory
    implements SshHmacFactory<HmacRipeMd160ETM> {
        @Override
        public HmacRipeMd160ETM create() throws NoSuchAlgorithmException, IOException {
            return new HmacRipeMd160ETM();
        }

        @Override
        public String[] getKeys() {
            return new String[]{HmacRipeMd160ETM.ALGORITHM};
        }
    }
}

