/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.AbstractFileSystem;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.extensions.AbstractSftpExtension;
import com.sshtools.common.util.ByteArrayReader;
import java.io.FileNotFoundException;
import java.io.IOException;

public class PosixRenameExtension
extends AbstractSftpExtension {
    public static final String EXTENSION_NAME = "posix-rename@openssh.com";

    public PosixRenameExtension() {
        super(EXTENSION_NAME, true);
    }

    @Override
    public void processMessage(ByteArrayReader msg, int requestId, SftpSubsystem sftp) {
        try {
            String oldpath = msg.readString();
            String newpath = msg.readString();
            AbstractFileSystem fs = sftp.getFileSystem();
            try {
                fs.getFileAttributes(newpath);
                fs.removeFile(newpath);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            sftp.getFileSystem().renameFile(oldpath, newpath);
            sftp.sendStatusMessage(requestId, 0, "Rename completed.");
        }
        catch (IOException e) {
            sftp.sendStatusMessage(requestId, 4, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            sftp.sendStatusMessage(requestId, 3, e.getMessage());
        }
    }

    @Override
    public boolean supportsExtendedMessage(int messageId) {
        return false;
    }

    @Override
    public void processExtendedMessage(ByteArrayReader msg, SftpSubsystem sftp) {
    }
}

