/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.publickey;

import com.sshtools.common.ssh.components.SshRsaPrivateKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import com.sshtools.common.util.Base64;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.StringTokenizer;
import javax.crypto.Cipher;

public class RsaUtils {
    public static String encrypt(SshRsaPrivateKey privateKey, String toEncrypt) throws Exception {
        int count;
        StringBuffer ret = new StringBuffer();
        int blockLength = privateKey.getModulus().bitLength() / 16;
        for (int pos = 0; pos < toEncrypt.length(); pos += count) {
            count = Math.min(toEncrypt.length() - pos, blockLength);
            ret.append(RsaUtils.doEncrypt(toEncrypt.substring(pos, pos + count), privateKey.getJCEPrivateKey()));
            ret.append('|');
        }
        return ret.toString();
    }

    public static String decrypt(SshRsaPublicKey publicKey, String toDecrypt) throws Exception {
        StringBuffer ret = new StringBuffer();
        StringTokenizer t = new StringTokenizer(toDecrypt, "|");
        while (t.hasMoreTokens()) {
            String data = t.nextToken();
            ret.append(RsaUtils.doDecrypt(data, publicKey.getJCEPublicKey()));
        }
        return ret.toString();
    }

    private static String doEncrypt(String toEncrypt, PrivateKey privateKey) throws Exception {
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        c.init(1, privateKey);
        return Base64.encodeBytes((byte[])c.doFinal(toEncrypt.getBytes("UTF-8")), (boolean)true);
    }

    private static String doDecrypt(String toDecrypt, PublicKey publicKey) throws Exception {
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        c.init(2, publicKey);
        return new String(c.doFinal(Base64.decode((String)toDecrypt)), "UTF-8");
    }

    public static String encrypt(SshRsaPublicKey publicKey, String toEncrypt) throws Exception {
        int count;
        StringBuffer ret = new StringBuffer();
        int blockLength = publicKey.getModulus().bitLength() / 16;
        for (int pos = 0; pos < toEncrypt.length(); pos += count) {
            count = Math.min(toEncrypt.length() - pos, blockLength);
            ret.append(RsaUtils.doEncrypt(toEncrypt.substring(pos, pos + count), publicKey.getJCEPublicKey()));
            ret.append('|');
        }
        return ret.toString();
    }

    public static String decrypt(SshRsaPrivateKey privateKey, String toDecrypt) throws Exception {
        StringBuffer ret = new StringBuffer();
        StringTokenizer t = new StringTokenizer(toDecrypt, "|");
        while (t.hasMoreTokens()) {
            String data = t.nextToken();
            ret.append(RsaUtils.doDecrypt(data, privateKey.getJCEPrivateKey()));
        }
        return ret.toString();
    }

    private static String doEncrypt(String toEncrypt, PublicKey publicKey) throws Exception {
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        c.init(1, publicKey);
        return Base64.encodeBytes((byte[])c.doFinal(toEncrypt.getBytes("UTF-8")), (boolean)true);
    }

    private static String doDecrypt(String toDecrypt, PrivateKey privateKey) throws Exception {
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        c.init(2, privateKey);
        return new String(c.doFinal(Base64.decode((String)toDecrypt)), "UTF-8");
    }

    public static String encryptOAEP(SshRsaPublicKey publicKey, String toEncrypt) throws Exception {
        int count;
        StringBuffer ret = new StringBuffer();
        int blockLength = publicKey.getModulus().bitLength() / 16;
        for (int pos = 0; pos < toEncrypt.length(); pos += count) {
            count = Math.min(toEncrypt.length() - pos, blockLength);
            ret.append(RsaUtils.doOAEPSHA256Encrypt(toEncrypt.substring(pos, pos + count), publicKey.getJCEPublicKey()));
            ret.append('|');
        }
        return ret.toString();
    }

    public static String decryptOAEP(SshRsaPrivateKey privateKey, String toDecrypt) throws Exception {
        StringBuffer ret = new StringBuffer();
        StringTokenizer t = new StringTokenizer(toDecrypt, "|");
        while (t.hasMoreTokens()) {
            String data = t.nextToken();
            ret.append(RsaUtils.doOAEPSHA256Decrypt(data, privateKey.getJCEPrivateKey()));
        }
        return ret.toString();
    }

    private static String doOAEPSHA256Encrypt(String toEncrypt, PublicKey publicKey) throws Exception {
        Cipher c = Cipher.getInstance("RSA/None/OAEPWithSHA256AndMGF1Padding");
        c.init(1, publicKey);
        return Base64.encodeBytes((byte[])c.doFinal(toEncrypt.getBytes("UTF-8")), (boolean)true);
    }

    private static String doOAEPSHA256Decrypt(String toDecrypt, PrivateKey privateKey) throws Exception {
        Cipher c = Cipher.getInstance("RSA/None/OAEPWithSHA256AndMGF1Padding");
        c.init(2, privateKey);
        return new String(c.doFinal(Base64.decode((String)toDecrypt)), "UTF-8");
    }
}

