/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.DigestFactory;
import com.sshtools.common.ssh.components.SshCipher;
import com.sshtools.common.ssh.components.SshCipherFactory;
import com.sshtools.common.ssh.components.SshDsaPrivateKey;
import com.sshtools.common.ssh.components.SshDsaPublicKey;
import com.sshtools.common.ssh.components.SshHmac;
import com.sshtools.common.ssh.components.SshHmacFactory;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshPublicKeyFactory;
import com.sshtools.common.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.common.ssh.components.SshRsaPrivateKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import com.sshtools.common.ssh.components.SshSecureRandomGenerator;
import com.sshtools.common.ssh.components.jce.AbstractDigest;
import com.sshtools.common.ssh.components.jce.AbstractHmac;
import com.sshtools.common.ssh.components.jce.AbstractJCECipher;
import com.sshtools.common.ssh.components.jce.JCEAlgorithms;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.ssh.components.jce.SecureRND;
import com.sshtools.common.ssh.components.jce.Ssh2DsaPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2DsaPublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2NistPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2NistPublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPrivateCrtKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKey;
import com.sshtools.common.ssh.components.jce.SshEd25519PrivateKeyJCE;
import com.sshtools.common.ssh.components.jce.SshEd25519PublicKeyJCE;
import com.sshtools.common.ssh.components.jce.SshEd448PrivateKeyJCE;
import com.sshtools.common.ssh.components.jce.SshEd448PublicKeyJCE;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.ServiceLoader;

public class JCEComponentManager
extends ComponentManager
implements JCEAlgorithms {
    SecureRND rnd;
    ClassLoader classLoader = JCEComponentManager.class.getClassLoader();

    public JCEComponentManager() {
        if ("executable".equals(System.getProperty("org.graalvm.nativeimage.kind", ""))) {
            Log.info((String)"Leaving provider configuration as running a native build.", (Object[])new Object[0]);
        } else {
            if (System.getProperty("maverick.enableBCProvider", "true").equalsIgnoreCase("false") || JCEProvider.isBCDisabled()) {
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Automatic configuration of BouncyCastle is disabled", (Object[])new Object[0]);
                }
                JCEProvider.disableBouncyCastle();
                return;
            }
            try {
                JCEProvider.enableBouncyCastle(false);
            }
            catch (IllegalStateException ex) {
                Log.error((String)"Bouncycastle JCE not found in classpath", (Object[])new Object[0]);
            }
        }
    }

    public static void initializeDefaultProvider(Provider provider) {
        JCEProvider.initializeDefaultProvider(provider);
    }

    public static void initializeProviderForAlgorithm(String jceAlgorithm, Provider provider) {
        JCEProvider.initializeProviderForAlgorithm(jceAlgorithm, provider);
    }

    public static String getSecureRandomAlgorithm() {
        return JCEProvider.getSecureRandomAlgorithm();
    }

    public static void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        JCEProvider.setSecureRandomAlgorithm(secureRandomAlgorithm);
    }

    public static Provider getProviderForAlgorithm(String jceAlgorithm) {
        return JCEProvider.getProviderForAlgorithm(jceAlgorithm);
    }

    public static SecureRandom getSecureRandom() {
        return JCEProvider.getSecureRandom();
    }

    @Override
    public SshDsaPrivateKey createDsaPrivateKey(BigInteger p, BigInteger q, BigInteger g, BigInteger x, BigInteger y) throws SshException {
        return new Ssh2DsaPrivateKey(p, q, g, x, y);
    }

    @Override
    public SshDsaPublicKey createDsaPublicKey(BigInteger p, BigInteger q, BigInteger g, BigInteger y) throws SshException {
        try {
            return new Ssh2DsaPublicKey(p, q, g, y);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshDsaPublicKey createDsaPublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger crtCoefficient) throws SshException {
        try {
            BigInteger primeExponentP = primeP.subtract(BigInteger.ONE);
            primeExponentP = privateExponent.mod(primeExponentP);
            BigInteger primeExponentQ = primeQ.subtract(BigInteger.ONE);
            primeExponentQ = privateExponent.mod(primeExponentQ);
            return new Ssh2RsaPrivateCrtKey(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) throws SshException {
        try {
            return new Ssh2RsaPrivateCrtKey(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPrivateKey createRsaPrivateKey(BigInteger modulus, BigInteger privateExponent) throws SshException {
        try {
            return new Ssh2RsaPrivateKey(modulus, privateExponent);
        }
        catch (Throwable t) {
            throw new SshException(t);
        }
    }

    @Override
    public SshRsaPublicKey createRsaPublicKey(BigInteger modulus, BigInteger publicExponent) throws SshException {
        try {
            return new Ssh2RsaPublicKey(modulus, publicExponent);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPublicKey createSsh2RsaPublicKey() throws SshException {
        return new Ssh2RsaPublicKey();
    }

    @Override
    public SshKeyPair generateDsaKeyPair(int bits) throws SshException {
        try {
            KeyPairGenerator keyGen = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyPairGenerator.getInstance("DSA") : KeyPairGenerator.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
            keyGen.initialize(bits);
            KeyPair keypair = keyGen.genKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            SshKeyPair pair = new SshKeyPair();
            pair.setPrivateKey(new Ssh2DsaPrivateKey((DSAPrivateKey)privateKey, (DSAPublicKey)publicKey));
            pair.setPublicKey(new Ssh2DsaPublicKey((DSAPublicKey)publicKey));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshKeyPair generateRsaKeyPair(int bits, int version) throws SshException {
        try {
            KeyPairGenerator keyGen = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyPairGenerator.getInstance("RSA") : KeyPairGenerator.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            keyGen.initialize(bits);
            KeyPair keypair = keyGen.genKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            SshKeyPair pair = new SshKeyPair();
            if (!(privateKey instanceof RSAPrivateCrtKey)) {
                throw new SshException("RSA key generation requires RSAPrivateCrtKey as private key type.", 16);
            }
            pair.setPrivateKey(new Ssh2RsaPrivateCrtKey((RSAPrivateCrtKey)privateKey));
            pair.setPublicKey(new Ssh2RsaPublicKey((RSAPublicKey)publicKey));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshKeyPair generateEd25519KeyPair() throws SshException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("Ed25519");
            KeyPair kp = keyGen.generateKeyPair();
            SshKeyPair pair = new SshKeyPair();
            pair.setPrivateKey(new SshEd25519PrivateKeyJCE(kp.getPrivate()));
            pair.setPublicKey(new SshEd25519PublicKeyJCE(kp.getPublic()));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshKeyPair generateEd448KeyPair() throws SshException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("Ed448");
            KeyPair kp = keyGen.generateKeyPair();
            SshKeyPair pair = new SshKeyPair();
            pair.setPrivateKey(new SshEd448PrivateKeyJCE(kp.getPrivate()));
            pair.setPublicKey(new SshEd448PublicKeyJCE(kp.getPublic()));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshKeyPair generateEcdsaKeyPair(int bits) throws SshException {
        String curve;
        switch (bits) {
            case 256: {
                curve = "secp256r1";
                break;
            }
            case 384: {
                curve = "secp384r1";
                break;
            }
            case 521: {
                curve = "secp521r1";
                break;
            }
            default: {
                throw new SshException("Unsupported size " + bits + " for ECDSA key (256,384,521 supported)", 4);
            }
        }
        try {
            ECGenParameterSpec ecGenSpec = new ECGenParameterSpec(curve);
            KeyPairGenerator g = KeyPairGenerator.getInstance(JCEProvider.getECDSAAlgorithmName());
            g.initialize(ecGenSpec, JCEProvider.getSecureRandom());
            KeyPair pair = g.generateKeyPair();
            SshKeyPair p = new SshKeyPair();
            p.setPrivateKey(new Ssh2EcdsaSha2NistPrivateKey((PrivateKey)((ECPrivateKey)pair.getPrivate()), curve));
            p.setPublicKey(new Ssh2EcdsaSha2NistPublicKey((ECPublicKey)pair.getPublic(), curve));
            return p;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshSecureRandomGenerator getRND() throws SshException {
        try {
            return this.rnd == null ? new SecureRND() : this.rnd;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    protected void initializeDigestFactory(ComponentFactory<Digest> digests) {
        for (DigestFactory digest : ServiceLoader.load(DigestFactory.class, JCEComponentManager.getDefaultInstance().getClassLoader())) {
            if (!this.testDigest(digest)) continue;
            digests.add(digest);
        }
    }

    @Override
    protected void initializeHmacFactory(ComponentFactory<SshHmac> hmacs) {
        for (SshHmacFactory hmac : ServiceLoader.load(SshHmacFactory.class, JCEComponentManager.getDefaultInstance().getClassLoader())) {
            if (!this.testHMac(hmac)) continue;
            hmacs.add(hmac);
        }
    }

    @Override
    protected void initializePublicKeyFactory(ComponentFactory<SshPublicKey> publickeys) {
        for (SshPublicKeyFactory pubkey : ServiceLoader.load(SshPublicKeyFactory.class, JCEComponentManager.getDefaultInstance().getClassLoader())) {
            if (!this.testPublicKey(pubkey)) continue;
            publickeys.add(pubkey);
        }
    }

    private boolean testPublicKey(SshPublicKeyFactory<SshPublicKey> cls) {
        String name = cls.getKeys()[0];
        try {
            if (!this.isEnabled(cls, SshPublicKey.class, name)) {
                return false;
            }
            SshPublicKey key = (SshPublicKey)cls.create();
            String provider = key.test();
            if (Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " will be supported using JCE Provider " + provider), (Object[])new Object[0]);
            }
            return true;
        }
        catch (Throwable e) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " will not be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    @Override
    protected void initializeSsh2CipherFactory(ComponentFactory<SshCipher> ciphers) {
        for (SshCipherFactory cipher : ServiceLoader.load(SshCipherFactory.class, JCEComponentManager.getDefaultInstance().getClassLoader())) {
            if (!this.testJCECipher(cipher)) continue;
            ciphers.add(cipher);
        }
    }

    private boolean testJCECipher(SshCipherFactory<SshCipher> cls) {
        String name = cls.getKeys()[0];
        SshCipher c = null;
        try {
            if (!this.isEnabled(cls, SshCipher.class, name)) {
                return false;
            }
            c = (SshCipher)cls.create();
            byte[] tmp = new byte[1024];
            JCEComponentManager.getSecureRandom().nextBytes(tmp);
            c.init(0, tmp, tmp);
            if (c instanceof AbstractJCECipher && Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " will be supported using JCE Provider " + ((AbstractJCECipher)c).getProvider()), (Object[])new Object[0]);
            }
            return true;
        }
        catch (Throwable e) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " WILL NOT be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    private boolean testDigest(DigestFactory<Digest> cls) {
        String name = cls.getKeys()[0];
        Digest c = null;
        try {
            if (!this.isEnabled(cls, Digest.class, name)) {
                return false;
            }
            c = (Digest)cls.create();
            if (c instanceof AbstractDigest && Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " will be supported using JCE Provider " + ((AbstractDigest)c).getProvider()), (Object[])new Object[0]);
            }
            return true;
        }
        catch (Throwable e) {
            if (Log.isInfoEnabled()) {
                if (c != null && ((AbstractDigest)c).getProvider() != null) {
                    Log.info((String)("   " + name + " WILL NOT be supported from JCE Provider " + ((AbstractDigest)c).getProvider() + ": " + e.getMessage()), (Object[])new Object[0]);
                } else {
                    Log.info((String)("   " + name + " WILL NOT be supported: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            return false;
        }
    }

    private boolean testHMac(SshHmacFactory<SshHmac> cls) {
        String name = cls.getKeys()[0];
        SshHmac c = null;
        try {
            if (!this.isEnabled(cls, SshHmac.class, name)) {
                return false;
            }
            c = (SshHmac)cls.create();
            byte[] tmp = new byte[1024];
            c.init(tmp);
            if (c instanceof AbstractHmac && Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " will be supported using JCE Provider " + ((AbstractHmac)c).getProvider()), (Object[])new Object[0]);
            }
            return true;
        }
        catch (Throwable e) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("   " + name + " WILL NOT be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ComponentManager getDefaultInstance() {
        return JCEComponentManager.getInstance();
    }
}

