/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.permissions;

import com.sshtools.common.logger.Log;
import com.sshtools.common.net.CIDRNetwork;
import com.sshtools.common.permissions.IPStore;
import com.sshtools.common.permissions.Permissions;
import com.sshtools.common.util.ExpiringConcurrentHashMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

public class IPPolicy
extends Permissions {
    static final int ALLOW_CONNECT = 1;
    static final int DISABLE_BAN = 2;
    IPStore blacklist = new IPStore();
    IPStore whitelist = new IPStore();
    ExpiringConcurrentHashMap<InetAddress, Integer> flaggedAddressCounts;
    int failedAuthenticationThreshold = 15;
    ExpiringConcurrentHashMap<InetAddress, Boolean> temporaryBans = new ExpiringConcurrentHashMap(TimeUnit.HOURS.toMillis(5L));

    public IPPolicy() {
        this.add(1);
        this.setFailedAuthenticationThresholdPeriod(5L, TimeUnit.MINUTES);
    }

    public void setFailedAuthenticationCountThreshold(int failedAuthenticationThreshold) {
        this.failedAuthenticationThreshold = failedAuthenticationThreshold;
    }

    public void setFailedAuthenticationThresholdPeriod(long failedAuthenticationThresholdPeriod, TimeUnit timeUnit) {
        this.flaggedAddressCounts = new ExpiringConcurrentHashMap(timeUnit.toMillis(failedAuthenticationThresholdPeriod));
    }

    public void setTemporaryBanTime(long minutes) {
        if (minutes <= 0L) {
            throw new IllegalArgumentException("Temporary ban period must be more than zero");
        }
        ExpiringConcurrentHashMap temporaryBans = new ExpiringConcurrentHashMap(TimeUnit.MINUTES.toMillis(minutes));
        temporaryBans.putAll(this.temporaryBans);
        this.temporaryBans = temporaryBans;
    }

    public void disableTemporaryBanning() {
        this.add(2);
    }

    public void enableTemporaryBanning() {
        this.remove(2);
    }

    public long getTemporaryBanTime() {
        return this.temporaryBans.getExpiryTime();
    }

    protected boolean assertConnection(InetAddress remoteAddress, InetAddress localAddress) {
        if (this.check(1)) {
            if (this.check(2)) {
                return true;
            }
            return this.assertAllowed(remoteAddress, localAddress);
        }
        return false;
    }

    protected boolean assertAllowed(InetAddress remoteAddress, InetAddress localAddress) {
        try {
            boolean allowed = true;
            Boolean temporarilyBanned = (Boolean)this.temporaryBans.getOrDefault((Object)remoteAddress, (Object)false);
            if (temporarilyBanned.booleanValue()) {
                Log.info((String)"Rejecting IP {} because of temporary ban", (Object[])new Object[]{remoteAddress.getHostAddress()});
                return false;
            }
            String addr = remoteAddress.getHostAddress();
            if (!this.whitelist.isEmpty()) {
                allowed = this.isListed(addr, this.whitelist);
            }
            boolean rejected = this.isListed(addr, this.blacklist);
            if (Log.isTraceEnabled()) {
                Log.trace((String)"{} is {} by IP policy", (Object[])new Object[]{remoteAddress.toString(), allowed && !rejected ? "allowed" : "denied"});
            }
            return allowed && !rejected;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP range");
        }
    }

    protected boolean isListed(String addr, IPStore store) throws UnknownHostException {
        for (CIDRNetwork value : store.getIPs()) {
            if (!value.isValidAddressForNetwork(addr)) continue;
            return true;
        }
        return false;
    }

    public void flagAddress(String addr) {
        try {
            this.flagAddress(InetAddress.getByName(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void flagAddress(InetAddress addr) {
        Integer count = (Integer)this.flaggedAddressCounts.getOrDefault((Object)addr, (Object)0);
        if (count >= this.failedAuthenticationThreshold) {
            Log.info((String)"Temporarily banning IP address {} due to failed authentication count of {}", (Object[])new Object[]{addr.getHostAddress(), count});
            this.temporaryBans.put((Object)addr, (Object)true);
            return;
        }
        count = count + 1;
        Log.info((String)"Flagging IP address {} with failed authentication count of {}", (Object[])new Object[]{addr.getHostAddress(), count});
        this.flaggedAddressCounts.put((Object)addr, (Object)count);
    }

    public final boolean checkConnection(InetAddress remoteAddress, InetAddress localAddress) {
        return this.assertConnection(remoteAddress, localAddress);
    }

    public final boolean checkConnection(String remoteAddress, String localAddress) {
        try {
            return this.assertConnection(InetAddress.getByAddress(this.convertAddress(remoteAddress)), InetAddress.getByAddress(this.convertAddress(remoteAddress)));
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private byte[] convertAddress(String str) {
        byte[] ret = new byte[4];
        String[] s = str.split("\\.");
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)Integer.parseInt(s[i], 10);
        }
        return ret;
    }

    public void stopAcceptingConnections() {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Stop accepting connections on IP Policy", (Object[])new Object[0]);
        }
        this.remove(1);
    }

    public void startAcceptingConnections() {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Start accepting connections on IP Policy", (Object[])new Object[0]);
        }
        this.add(1);
    }

    public void blacklist(String addr) throws UnknownHostException {
        Log.info((String)"Blacklisting IP address {}", (Object[])new Object[]{addr});
        this.blacklist.add(addr);
    }

    public void whitelist(String addr) throws UnknownHostException {
        Log.info((String)"Whitelisting IP address {}", (Object[])new Object[]{addr});
        this.whitelist.add(addr);
    }

    public IPStore getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(IPStore blacklist) {
        this.blacklist = blacklist;
    }

    public IPStore getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(IPStore whitelist) {
        this.whitelist = whitelist;
    }
}

