/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshCipher;
import com.sshtools.common.ssh.components.SshDsaPrivateKey;
import com.sshtools.common.ssh.components.SshDsaPublicKey;
import com.sshtools.common.ssh.components.SshHmac;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.common.ssh.components.SshRsaPrivateKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import com.sshtools.common.ssh.components.SshSecureRandomGenerator;
import com.sshtools.common.ssh.components.jce.AES128Ctr;
import com.sshtools.common.ssh.components.jce.AES128Gcm;
import com.sshtools.common.ssh.components.jce.AES192Ctr;
import com.sshtools.common.ssh.components.jce.AES256Ctr;
import com.sshtools.common.ssh.components.jce.AES256Gcm;
import com.sshtools.common.ssh.components.jce.AbstractDigest;
import com.sshtools.common.ssh.components.jce.AbstractHmac;
import com.sshtools.common.ssh.components.jce.AbstractJCECipher;
import com.sshtools.common.ssh.components.jce.ChaCha20Poly1305;
import com.sshtools.common.ssh.components.jce.HmacSha1;
import com.sshtools.common.ssh.components.jce.HmacSha196;
import com.sshtools.common.ssh.components.jce.HmacSha1ETM;
import com.sshtools.common.ssh.components.jce.HmacSha256;
import com.sshtools.common.ssh.components.jce.HmacSha256ETM;
import com.sshtools.common.ssh.components.jce.HmacSha256_96;
import com.sshtools.common.ssh.components.jce.HmacSha512;
import com.sshtools.common.ssh.components.jce.HmacSha512ETM;
import com.sshtools.common.ssh.components.jce.HmacSha512_96;
import com.sshtools.common.ssh.components.jce.JCEAlgorithms;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.ssh.components.jce.MD5Digest;
import com.sshtools.common.ssh.components.jce.OpenSshEcdsaSha2Nist256Certificate;
import com.sshtools.common.ssh.components.jce.OpenSshEcdsaSha2Nist384Certificate;
import com.sshtools.common.ssh.components.jce.OpenSshEcdsaSha2Nist521Certificate;
import com.sshtools.common.ssh.components.jce.OpenSshEd25519Certificate;
import com.sshtools.common.ssh.components.jce.OpenSshRsaCertificate;
import com.sshtools.common.ssh.components.jce.SHA1Digest;
import com.sshtools.common.ssh.components.jce.SHA256Digest;
import com.sshtools.common.ssh.components.jce.SHA384Digest;
import com.sshtools.common.ssh.components.jce.SHA512Digest;
import com.sshtools.common.ssh.components.jce.SecureRND;
import com.sshtools.common.ssh.components.jce.Ssh2DsaPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2DsaPublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2Nist256PublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2Nist384PublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2Nist521PublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2NistPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2NistPublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPrivateCrtKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKeySHA256;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKeySHA512;
import com.sshtools.common.ssh.components.jce.SshEd25519PrivateKeyJCE;
import com.sshtools.common.ssh.components.jce.SshEd25519PublicKeyJCE;
import com.sshtools.common.ssh.components.jce.TripleDesCtr;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;

public class JCEComponentManager
extends ComponentManager
implements JCEAlgorithms {
    SecureRND rnd;

    public JCEComponentManager() {
        if (System.getProperty("maverick.enableBCProvider", "true").equalsIgnoreCase("false") || JCEProvider.isBCDisabled()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Automatic configuration of BouncyCastle is disabled", (Object[])new Object[0]);
            }
            JCEProvider.disableBouncyCastle();
            return;
        }
        try {
            JCEProvider.enableBouncyCastle(false);
        }
        catch (IllegalStateException ex) {
            Log.error((String)"Bouncycastle JCE not found in classpath", (Object[])new Object[0]);
        }
    }

    public static void initializeDefaultProvider(Provider provider) {
        JCEProvider.initializeDefaultProvider(provider);
    }

    public static void initializeProviderForAlgorithm(String jceAlgorithm, Provider provider) {
        JCEProvider.initializeProviderForAlgorithm(jceAlgorithm, provider);
    }

    public static String getSecureRandomAlgorithm() {
        return JCEProvider.getSecureRandomAlgorithm();
    }

    public static void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        JCEProvider.setSecureRandomAlgorithm(secureRandomAlgorithm);
    }

    public static Provider getProviderForAlgorithm(String jceAlgorithm) {
        return JCEProvider.getProviderForAlgorithm(jceAlgorithm);
    }

    public static SecureRandom getSecureRandom() {
        return JCEProvider.getSecureRandom();
    }

    @Override
    public SshDsaPrivateKey createDsaPrivateKey(BigInteger p, BigInteger q, BigInteger g, BigInteger x, BigInteger y) throws SshException {
        return new Ssh2DsaPrivateKey(p, q, g, x, y);
    }

    @Override
    public SshDsaPublicKey createDsaPublicKey(BigInteger p, BigInteger q, BigInteger g, BigInteger y) throws SshException {
        try {
            return new Ssh2DsaPublicKey(p, q, g, y);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshDsaPublicKey createDsaPublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger crtCoefficient) throws SshException {
        try {
            BigInteger primeExponentP = primeP.subtract(BigInteger.ONE);
            primeExponentP = privateExponent.mod(primeExponentP);
            BigInteger primeExponentQ = primeQ.subtract(BigInteger.ONE);
            primeExponentQ = privateExponent.mod(primeExponentQ);
            return new Ssh2RsaPrivateCrtKey(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) throws SshException {
        try {
            return new Ssh2RsaPrivateCrtKey(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPrivateKey createRsaPrivateKey(BigInteger modulus, BigInteger privateExponent) throws SshException {
        try {
            return new Ssh2RsaPrivateKey(modulus, privateExponent);
        }
        catch (Throwable t) {
            throw new SshException(t);
        }
    }

    @Override
    public SshRsaPublicKey createRsaPublicKey(BigInteger modulus, BigInteger publicExponent) throws SshException {
        try {
            return new Ssh2RsaPublicKey(modulus, publicExponent);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPublicKey createSsh2RsaPublicKey() throws SshException {
        return new Ssh2RsaPublicKey();
    }

    @Override
    public SshKeyPair generateDsaKeyPair(int bits) throws SshException {
        try {
            KeyPairGenerator keyGen = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyPairGenerator.getInstance("DSA") : KeyPairGenerator.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
            keyGen.initialize(bits);
            KeyPair keypair = keyGen.genKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            SshKeyPair pair = new SshKeyPair();
            pair.setPrivateKey(new Ssh2DsaPrivateKey((DSAPrivateKey)privateKey, (DSAPublicKey)publicKey));
            pair.setPublicKey(new Ssh2DsaPublicKey((DSAPublicKey)publicKey));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshKeyPair generateRsaKeyPair(int bits, int version) throws SshException {
        try {
            KeyPairGenerator keyGen = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyPairGenerator.getInstance("RSA") : KeyPairGenerator.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            keyGen.initialize(bits);
            KeyPair keypair = keyGen.genKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            SshKeyPair pair = new SshKeyPair();
            if (!(privateKey instanceof RSAPrivateCrtKey)) {
                throw new SshException("RSA key generation requires RSAPrivateCrtKey as private key type.", 16);
            }
            pair.setPrivateKey(new Ssh2RsaPrivateCrtKey((RSAPrivateCrtKey)privateKey));
            pair.setPublicKey(new Ssh2RsaPublicKey((RSAPublicKey)publicKey));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshKeyPair generateEd25519KeyPair() throws SshException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("Ed25519");
            KeyPair kp = keyGen.generateKeyPair();
            SshKeyPair pair = new SshKeyPair();
            pair.setPrivateKey(new SshEd25519PrivateKeyJCE(kp.getPrivate()));
            pair.setPublicKey(new SshEd25519PublicKeyJCE(kp.getPublic()));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshKeyPair generateEcdsaKeyPair(int bits) throws SshException {
        String curve;
        switch (bits) {
            case 256: {
                curve = "secp256r1";
                break;
            }
            case 384: {
                curve = "secp384r1";
                break;
            }
            case 521: {
                curve = "secp521r1";
                break;
            }
            default: {
                throw new SshException("Unsupported size " + bits + " for ECDSA key (256,384,521 supported)", 4);
            }
        }
        try {
            ECGenParameterSpec ecGenSpec = new ECGenParameterSpec(curve);
            KeyPairGenerator g = KeyPairGenerator.getInstance(JCEProvider.getECDSAAlgorithmName());
            g.initialize(ecGenSpec, JCEProvider.getSecureRandom());
            KeyPair pair = g.generateKeyPair();
            SshKeyPair p = new SshKeyPair();
            p.setPrivateKey(new Ssh2EcdsaSha2NistPrivateKey((PrivateKey)((ECPrivateKey)pair.getPrivate()), curve));
            p.setPublicKey(new Ssh2EcdsaSha2NistPublicKey((ECPublicKey)pair.getPublic(), curve));
            return p;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshSecureRandomGenerator getRND() throws SshException {
        try {
            return this.rnd == null ? new SecureRND() : this.rnd;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    protected void initializeDigestFactory(ComponentFactory<Digest> digests) {
        if (JCEComponentManager.testDigest("MD5", MD5Digest.class)) {
            digests.add("MD5", MD5Digest.class);
        }
        if (JCEComponentManager.testDigest("SHA-1", SHA1Digest.class)) {
            digests.add("SHA-1", SHA1Digest.class);
        }
        if (JCEComponentManager.testDigest("SHA1", SHA1Digest.class)) {
            digests.add("SHA1", SHA1Digest.class);
        }
        if (JCEComponentManager.testDigest("SHA-256", SHA256Digest.class)) {
            digests.add("SHA-256", SHA256Digest.class);
            digests.add("SHA256", SHA256Digest.class);
        }
        if (JCEComponentManager.testDigest("SHA-384", SHA384Digest.class)) {
            digests.add("SHA-384", SHA384Digest.class);
            digests.add("SHA384", SHA384Digest.class);
        }
        if (JCEComponentManager.testDigest("SHA-512", SHA512Digest.class)) {
            digests.add("SHA-512", SHA512Digest.class);
            digests.add("SHA512", SHA512Digest.class);
        }
        this.loadExternalComponents("digest.properties", digests);
    }

    @Override
    protected void initializeHmacFactory(ComponentFactory<SshHmac> hmacs) {
        if (this.testHMac("hmac-sha2-256", HmacSha256.class)) {
            hmacs.add("hmac-sha2-256", HmacSha256.class);
            hmacs.add("hmac-sha2-256-etm@openssh.com", HmacSha256ETM.class);
        }
        if (this.testHMac("hmac-sha2-256-96", HmacSha256_96.class)) {
            hmacs.add("hmac-sha2-256-96", HmacSha256_96.class);
        }
        if (this.testHMac("hmac-sha2-512", HmacSha512.class)) {
            hmacs.add("hmac-sha2-512", HmacSha512.class);
            hmacs.add("hmac-sha2-512-etm@openssh.com", HmacSha512ETM.class);
        }
        if (this.testHMac("hmac-sha2-512-96", HmacSha512_96.class)) {
            hmacs.add("hmac-sha2-512-96", HmacSha512_96.class);
        }
        if (this.testHMac("hmac-sha1", HmacSha1.class)) {
            hmacs.add("hmac-sha1", HmacSha1.class);
            hmacs.add("hmac-sha1-etm@openssh.com", HmacSha1ETM.class);
        }
        if (this.testHMac("hmac-sha1-96", HmacSha196.class)) {
            hmacs.add("hmac-sha1-96", HmacSha196.class);
        }
        this.loadExternalComponents("hmac.properties", hmacs);
    }

    @Override
    protected void initializePublicKeyFactory(ComponentFactory<SshPublicKey> publickeys) {
        this.testPublicKey("ssh-ed25519", SshEd25519PublicKeyJCE.class, publickeys);
        this.testPublicKey("rsa-sha2-256", Ssh2RsaPublicKeySHA256.class, publickeys);
        this.testPublicKey("rsa-sha2-512", Ssh2RsaPublicKeySHA512.class, publickeys);
        this.testPublicKey("ecdsa-sha2-nistp256", Ssh2EcdsaSha2Nist256PublicKey.class, publickeys);
        this.testPublicKey("ecdsa-sha2-nistp384", Ssh2EcdsaSha2Nist384PublicKey.class, publickeys);
        this.testPublicKey("ecdsa-sha2-nistp521", Ssh2EcdsaSha2Nist521PublicKey.class, publickeys);
        this.testPublicKey("ssh-rsa-cert-v01@openssh.com", OpenSshRsaCertificate.class, publickeys);
        this.testPublicKey("ecdsa-sha2-nistp256-cert-v01@openssh.com", OpenSshEcdsaSha2Nist256Certificate.class, publickeys);
        this.testPublicKey("ecdsa-sha2-nistp384-cert-v01@openssh.com", OpenSshEcdsaSha2Nist384Certificate.class, publickeys);
        this.testPublicKey("ecdsa-sha2-nistp521-cert-v01@openssh.com", OpenSshEcdsaSha2Nist521Certificate.class, publickeys);
        this.testPublicKey("ssh-ed25519-cert-v01@openssh.com", OpenSshEd25519Certificate.class, publickeys);
        this.loadExternalComponents("publickey.properties", publickeys);
        this.testPublicKey("ssh-rsa", Ssh2RsaPublicKey.class, publickeys);
        this.testPublicKey("ssh-dss", Ssh2DsaPublicKey.class, publickeys);
    }

    private void testPublicKey(String name, Class<? extends SshPublicKey> pub, ComponentFactory<SshPublicKey> publickeys) {
        block5: {
            if (System.getProperties().containsKey(String.format("disable.%s", name))) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"   {} WILL NOT be supported because it has been explicitly disabled by a system property", (Object[])new Object[]{name});
                }
                return;
            }
            try {
                SshPublicKey key = pub.newInstance();
                String provider = key.test();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("   " + name + " will be supported using JCE Provider " + provider), (Object[])new Object[0]);
                }
                publickeys.add(name, pub);
            }
            catch (Throwable e) {
                if (!Log.isDebugEnabled()) break block5;
                Log.debug((String)("   " + name + " will not be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    protected void initializeSsh2CipherFactory(ComponentFactory<SshCipher> ciphers) {
        if (this.testJCECipher("chacha20-poly1305@openssh.com", ChaCha20Poly1305.class)) {
            ciphers.add("chacha20-poly1305@openssh.com", ChaCha20Poly1305.class);
        }
        if (this.testJCECipher("aes128-ctr", AES128Ctr.class)) {
            ciphers.add("aes128-ctr", AES128Ctr.class);
        }
        if (this.testJCECipher("aes192-ctr", AES192Ctr.class)) {
            ciphers.add("aes192-ctr", AES192Ctr.class);
        }
        if (this.testJCECipher("aes256-ctr", AES256Ctr.class)) {
            ciphers.add("aes256-ctr", AES256Ctr.class);
        }
        if (this.testJCECipher("3des-ctr", TripleDesCtr.class)) {
            ciphers.add("3des-ctr", TripleDesCtr.class);
        }
        if (this.testJCECipher("aes128-gcm@openssh.com", AES128Gcm.class)) {
            ciphers.add("aes128-gcm@openssh.com", AES128Gcm.class);
        }
        if (this.testJCECipher("aes256-gcm@openssh.com", AES256Gcm.class)) {
            ciphers.add("aes256-gcm@openssh.com", AES256Gcm.class);
        }
        this.loadExternalComponents("cipher.properties", ciphers);
    }

    public boolean testJCECipher(String name, Class<? extends SshCipher> cls) {
        if (System.getProperties().containsKey(String.format("disable.%s", name))) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"   {} WILL NOT be supported because it has been explicitly disabled by a system property", (Object[])new Object[]{name});
            }
            return false;
        }
        SshCipher c = null;
        try {
            c = cls.newInstance();
            byte[] tmp = new byte[1024];
            JCEComponentManager.getSecureRandom().nextBytes(tmp);
            c.init(0, tmp, tmp);
            if (c instanceof AbstractJCECipher && Log.isDebugEnabled()) {
                Log.debug((String)("   " + name + " will be supported using JCE Provider " + ((AbstractJCECipher)c).getProvider()), (Object[])new Object[0]);
            }
            return true;
        }
        catch (Throwable e) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("   " + name + " WILL NOT be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    public static boolean testDigest(String name, Class<? extends Digest> cls) {
        if (System.getProperties().containsKey(String.format("disable.%s", name))) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"   {} WILL NOT be supported because it has been explicitly disabled by a system property", (Object[])new Object[]{name});
            }
            return false;
        }
        Digest c = null;
        try {
            c = cls.newInstance();
            if (c instanceof AbstractDigest && Log.isDebugEnabled()) {
                Log.debug((String)("   " + name + " will be supported using JCE Provider " + ((AbstractDigest)c).getProvider()), (Object[])new Object[0]);
            }
            return true;
        }
        catch (Throwable e) {
            if (Log.isDebugEnabled()) {
                if (c != null && ((AbstractDigest)c).getProvider() != null) {
                    Log.debug((String)("   " + name + " WILL NOT be supported from JCE Provider " + ((AbstractDigest)c).getProvider() + ": " + e.getMessage()), (Object[])new Object[0]);
                } else {
                    Log.debug((String)("   " + name + " WILL NOT be supported: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            return false;
        }
    }

    private boolean testHMac(String name, Class<? extends SshHmac> cls) {
        if (System.getProperties().containsKey(String.format("disable.%s", name))) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"   {} WILL NOT be supported because it has been explicitly disabled by a system property", (Object[])new Object[]{name});
            }
            return false;
        }
        SshHmac c = null;
        try {
            c = cls.newInstance();
            byte[] tmp = new byte[1024];
            c.init(tmp);
            if (c instanceof AbstractHmac && Log.isDebugEnabled()) {
                Log.debug((String)("   " + name + " will be supported using JCE Provider " + ((AbstractHmac)c).getProvider()), (Object[])new Object[0]);
            }
            return true;
        }
        catch (Throwable e) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("   " + name + " WILL NOT be supported: " + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    public static ComponentManager getDefaultInstance() {
        return JCEComponentManager.getInstance();
    }
}

