/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.scp;

import com.sshtools.common.command.ExecutableCommand;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.scp.ScpPolicy;
import com.sshtools.common.sftp.AbstractFileSystem;
import com.sshtools.common.sftp.InvalidHandleException;
import com.sshtools.common.sftp.SftpFile;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import com.sshtools.common.util.Utils;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;

public class ScpCommand
extends ExecutableCommand
implements Runnable {
    private static int BUFFER_SIZE = 16384;
    private String destination;
    private int verbosity = 0;
    private int exitCode = Integer.MIN_VALUE;
    private boolean directory;
    private boolean recursive;
    private boolean from;
    private boolean to;
    private AbstractFileSystem nfs;
    private byte[] buffer = new byte[BUFFER_SIZE];
    private boolean preserveAttributes;
    private boolean firstPath = true;
    private String currentDirectory;
    private FileSystemPolicy filePolicy;

    public ScpCommand() {
        this(".");
    }

    public ScpCommand(String currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    @Override
    public boolean createProcess(String[] args, Map<String, String> environment) {
        block5: {
            String command = Utils.mergeToArgsString((String[])args);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Creating SCP with command line '{}' and current working directory '{}'", (Object[])new Object[]{command, this.currentDirectory});
            }
            try {
                this.nfs = new AbstractFileSystem(this.session.getConnection(), "scp");
                this.scp(Arrays.copyOfRange(args, 1, args.length));
                return true;
            }
            catch (IOException ex) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Failed to start command: {}", (Throwable)ex, (Object[])new Object[]{command});
                }
            }
            catch (Throwable t) {
                if (!Log.isDebugEnabled()) break block5;
                Log.debug((String)"SCP command could not be processed: {}", (Throwable)t, (Object[])new Object[]{command});
            }
        }
        return false;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void kill() {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Killing SCP command", (Object[])new Object[0]);
        }
        try {
            this.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onStart() {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Adding SCP command to executor service", (Object[])new Object[0]);
        }
        this.session.getConnection().executeTask(new ConnectionAwareTask(this.session.getConnection()){

            @Override
            protected void doTask() {
                ScpCommand.this.run();
            }
        });
    }

    private void scp(String[] a) throws IOException {
        int i;
        this.destination = null;
        this.directory = false;
        this.from = false;
        this.to = false;
        this.recursive = false;
        this.verbosity = 0;
        int pathIndex = 0;
        for (i = 0; i < a.length && a[i].startsWith("-"); ++i) {
            ++pathIndex;
        }
        for (i = 0; i < pathIndex; ++i) {
            String s = a[i].substring(1);
            block10: for (int j = 0; j < s.length(); ++j) {
                char ch = s.charAt(j);
                switch (ch) {
                    case 't': {
                        this.to = true;
                        continue block10;
                    }
                    case 'd': {
                        this.directory = true;
                        continue block10;
                    }
                    case 'f': {
                        this.from = true;
                        continue block10;
                    }
                    case 'r': {
                        this.recursive = true;
                        continue block10;
                    }
                    case 'v': {
                        ++this.verbosity;
                        continue block10;
                    }
                    case 'p': {
                        this.preserveAttributes = true;
                        continue block10;
                    }
                    default: {
                        if (!Log.isDebugEnabled()) continue block10;
                        Log.debug((String)"Unsupported SCP argument {}", (Object[])new Object[]{Character.valueOf(ch)});
                    }
                }
            }
        }
        for (i = pathIndex; i < a.length; ++i) {
            if (this.destination == null) {
                this.destination = a[i];
                continue;
            }
            if (this.destination.endsWith("\\")) {
                this.destination = this.destination.substring(0, this.destination.length() - 1);
            }
            this.destination = this.destination + " " + a[i];
        }
        if (!this.to && !this.from) {
            throw new IOException("Must supply either -t or -f.");
        }
        if (this.destination == null) {
            throw new IOException("Destination not supplied.");
        }
        this.destination = this.destination.trim();
        if (this.destination.startsWith("\"") && this.destination.endsWith("\"")) {
            this.destination = this.destination.substring(1, this.destination.length() - 1);
        }
        if (this.destination.startsWith("'") && this.destination.endsWith("'")) {
            this.destination = this.destination.substring(1, this.destination.length() - 1);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Destination is {}", (Object[])new Object[]{this.destination});
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Recursive is {}", (Object[])new Object[]{this.recursive});
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Directory is {}", (Object[])new Object[]{this.directory});
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Verbosity is {}", (Object[])new Object[]{this.verbosity});
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Sending files is {}", (Object[])new Object[]{this.from});
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Receiving files is {}", (Object[])new Object[]{this.to});
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Preserve Attributes {}", (Object[])new Object[]{this.preserveAttributes});
        }
    }

    private void writeOk() throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Sending client OK command", (Object[])new Object[0]);
        }
        this.getOutputStream().write(0);
    }

    private void writeCommand(String cmd) throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Sending command '{}'", (Object[])new Object[]{cmd});
        }
        this.getOutputStream().write(cmd.getBytes());
        if (!cmd.endsWith("\n")) {
            this.getOutputStream().write("\n".getBytes());
        }
    }

    private void writeError(String msg) throws IOException {
        this.writeError(msg, false);
    }

    private void writeError(String msg, boolean serious) throws IOException {
        this.exitCode = 1;
        if (this.session.isClosed()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"SCP received error '{}' but session is closed so cannot inform client", (Object[])new Object[]{msg});
            }
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending error message '{}' to client (serious={})", (Object[])new Object[]{msg, serious});
            }
            this.getOutputStream().write(serious ? 2 : 1);
            this.getOutputStream().write(msg.getBytes());
            if (!msg.endsWith("\n")) {
                this.getOutputStream().write("\n".getBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"SCP thread has started", (Object[])new Object[0]);
        }
        try {
            if (this.from) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"SCP is sending files to client", (Object[])new Object[0]);
                }
                try {
                    int idx;
                    this.waitForResponse();
                    String base = this.destination;
                    String dir = this.currentDirectory;
                    if (this.destination.startsWith("/")) {
                        dir = "";
                    }
                    if ((idx = base.lastIndexOf(47)) != -1) {
                        if (idx > 0) {
                            dir = base.substring(0, idx);
                        }
                        base = base.substring(idx + 1);
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Looking for matches in {} for {}", (Object[])new Object[]{dir, base});
                    }
                    PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + base);
                    byte[] handle = null;
                    boolean eof = false;
                    boolean found = false;
                    try {
                        handle = this.nfs.openDirectory(dir);
                        while (!eof) {
                            try {
                                SftpFile[] files = this.nfs.readDirectory(handle);
                                for (int i = 0; i < files.length; ++i) {
                                    if (Log.isDebugEnabled()) {
                                        Log.debug((String)"Testing for match against {}", (Object[])new Object[]{files[i].getFilename()});
                                    }
                                    if (files[i].getFilename().equals(".") || files[i].getFilename().equals("..")) continue;
                                    if (matcher.matches(Paths.get(files[i].getFilename(), new String[0]))) {
                                        if (Log.isDebugEnabled()) {
                                            Log.debug((String)"Matched", (Object[])new Object[0]);
                                        }
                                        found = true;
                                        this.writeFileToRemote(dir + "/" + files[i].getFilename());
                                        continue;
                                    }
                                    if (!Log.isDebugEnabled()) continue;
                                    Log.debug((String)"No match", (Object[])new Object[0]);
                                }
                            }
                            catch (EOFException e) {
                                eof = true;
                            }
                        }
                    }
                    finally {
                        if (handle != null) {
                            try {
                                this.nfs.closeFile(handle);
                            }
                            catch (InvalidHandleException invalidHandleException) {}
                        }
                        if (eof && !found) {
                            this.writeError(base + " not found", true);
                        }
                    }
                }
                catch (FileNotFoundException fnfe) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"", (Throwable)fnfe, (Object[])new Object[0]);
                    }
                    this.writeError(fnfe.getMessage(), true);
                }
                catch (PermissionDeniedException pde) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"", (Throwable)pde, (Object[])new Object[0]);
                    }
                    this.writeError(pde.getMessage(), true);
                }
                catch (InvalidHandleException ihe) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"", (Throwable)ihe, (Object[])new Object[0]);
                    }
                    this.writeError(ihe.getMessage(), true);
                }
                catch (IOException ioe) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"", (Throwable)ioe, (Object[])new Object[0]);
                    }
                    this.writeError(ioe.getMessage(), true);
                }
            } else {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"SCP is receiving files from the client", (Object[])new Object[0]);
                }
                this.readFromRemote(this.destination);
            }
            this.exitCode = 0;
        }
        catch (Throwable t) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"SCP thread failed", (Throwable)t, (Object[])new Object[0]);
            }
            this.exitCode = 1;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"SCP thread is exiting", (Object[])new Object[0]);
        }
        this.nfs.closeFilesystem();
        this.closeSession();
    }

    protected void closeSession() {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Closing session", (Object[])new Object[0]);
        }
        if (!this.session.isClosed()) {
            this.session.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeDirToRemote(String path) throws IOException {
        byte[] handle;
        block21: {
            SftpFile[] list;
            handle = null;
            try {
                SftpFileAttributes attr = this.nfs.getFileAttributes(path);
                if (attr.isDirectory() && !this.recursive) {
                    this.writeError("File " + path + " is a directory, use recursive mode");
                    boolean bl = false;
                    return bl;
                }
                String basename = path;
                int idx = path.lastIndexOf(47);
                if (idx != -1) {
                    basename = path.substring(idx + 1);
                }
                this.writeCommand("D" + attr.getMaskString() + " 0 " + basename + "\n");
                this.waitForResponse();
                handle = this.nfs.openDirectory(path);
                try {}
                catch (EOFException eOFException) {
                    // empty catch block
                    break block21;
                }
            }
            catch (InvalidHandleException ihe) {
                throw new IOException(ihe.getMessage());
            }
            catch (PermissionDeniedException e) {
                throw new IOException(e.getMessage());
            }
            do {
                list = this.nfs.readDirectory(handle);
                for (int i = 0; i < list.length; ++i) {
                    if (list[i].getFilename().equals(".") || list[i].getFilename().equals("..")) continue;
                    this.writeFileToRemote(path + "/" + list[i].getFilename());
                }
            } while (list.length > 0);
        }
        this.writeCommand("E");
        this.waitForResponse();
        if (handle == null) return true;
        try {
            this.nfs.closeFile(handle);
            return true;
        }
        catch (Exception e) {
            if (!Log.isDebugEnabled()) return true;
            Log.debug((String)"", (Throwable)e, (Object[])new Object[0]);
            return true;
        }
        finally {
            block22: {
                if (handle != null) {
                    try {
                        this.nfs.closeFile(handle);
                    }
                    catch (Exception e) {
                        if (!Log.isDebugEnabled()) break block22;
                        Log.debug((String)"", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFileToRemote(String path) throws IOException, PermissionDeniedException, InvalidHandleException {
        block24: {
            SftpFileAttributes attr = this.nfs.getFileAttributes(path);
            if (attr.isDirectory()) {
                if (!this.writeDirToRemote(path)) {
                    return;
                }
            } else {
                if (!attr.isFile()) throw new IOException(path + " not valid for SCP.");
                String basename = path;
                int idx = basename.lastIndexOf(47);
                if (idx != -1) {
                    basename = path.substring(idx + 1);
                }
                this.writeCommand("C" + attr.getMaskString() + " " + attr.getSize() + " " + basename + "\n");
                this.waitForResponse();
                Date started = new Date();
                path = this.nfs.getRealPath(path);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Opening file {}", (Object[])new Object[]{path});
                }
                this.fireEvent(new Event((Object)this, -16777145, true).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("BYTES_EXPECTED", new Long(attr.getSize().longValue())).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()).addAttribute("CONNECTION", this.session.getConnection()));
                byte[] handle = null;
                long count = 0L;
                handle = this.nfs.openFile(path, new UnsignedInteger32(1L), attr);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sending file", (Object[])new Object[0]);
                }
                this.fireEvent(new Event((Object)this, -16777149, true).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("BYTES_EXPECTED", new Long(attr.getSize().longValue())).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()).addAttribute("HANDLE", handle).addAttribute("CONNECTION", this.session.getConnection()));
                UnsignedInteger64 offset = new UnsignedInteger64(count);
                byte[] buf = null;
                while (count < attr.getSize().longValue()) {
                    try {
                        buf = new byte[BUFFER_SIZE];
                        int read = this.nfs.readFile(handle, offset, buf, 0, buf.length);
                        if (read < 0) break;
                        offset = UnsignedInteger64.add((UnsignedInteger64)offset, (int)read);
                        count += (long)read;
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Writing block of {} bytes", (Object[])new Object[]{read});
                        }
                        this.getOutputStream().write(buf, 0, read);
                        if (!this.session.getConnection().getContext().getPolicy(ScpPolicy.class).isSCPReadWriteEvents()) continue;
                        this.fireEvent(new Event((Object)this, -16777148, true).addAttribute("CONNECTION", this.session.getConnection()).addAttribute("BYTES_TRANSFERED", new Long(count)).addAttribute("BYTES_READ", new Long(read)).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("HANDLE", handle).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()));
                    }
                    catch (EOFException eofe) {
                        if (!Log.isDebugEnabled()) break;
                        Log.debug((String)"End of file - finishing transfer", (Object[])new Object[0]);
                        break;
                    }
                }
                if (count < attr.getSize().longValue()) {
                    throw new IOException("File transfer terminated abnormally.");
                }
                this.fireEvent(new Event((Object)this, -16777151, true).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("BYTES_TRANSFERED", new Long(count)).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()).addAttribute("HANDLE", handle).addAttribute("CONNECTION", this.session.getConnection()));
                this.writeOk();
                this.waitForResponse();
                if (handle == null) break block24;
                try {
                    this.nfs.closeFile(handle);
                }
                catch (Exception e) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"", (Throwable)e, (Object[])new Object[0]);
                    }
                    break block24;
                }
                catch (Throwable ex) {
                    try {
                        if (Log.isErrorEnabled()) {
                            Log.error((String)"Write to remote failed", (Throwable)ex, (Object[])new Object[0]);
                        }
                        this.fireDownloadErrorEvent(handle, path, started, count, ex, this.session.getConnection());
                        if (handle == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (handle == null) throw throwable;
                        try {
                            this.nfs.closeFile(handle);
                            throw throwable;
                        }
                        catch (Exception e) {
                            if (!Log.isDebugEnabled()) throw throwable;
                            Log.debug((String)"", (Throwable)e, (Object[])new Object[0]);
                        }
                        throw throwable;
                    }
                    try {
                        this.nfs.closeFile(handle);
                    }
                    catch (Exception e) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"", (Throwable)e, (Object[])new Object[0]);
                        }
                    }
                }
            }
        }
        this.exitCode = 0;
    }

    private void fireDownloadErrorEvent(byte[] handle, String path, Date started, long count, Throwable ex, SshConnection con) {
        this.fireEvent(new Event((Object)this, -16777151, ex).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("BYTES_TRANSFERED", new Long(count)).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()).addAttribute("HANDLE", handle).addAttribute("CONNECTION", this.session.getConnection()));
    }

    private void fireEvent(Event event) {
        this.nfs.populateEvent(event);
        EventServiceImplementation.getInstance().fireEvent(event);
    }

    private void waitForResponse() throws IOException {
        int r;
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Waiting for response", (Object[])new Object[0]);
        }
        if ((r = this.getInputStream().read()) == 0) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Got OK", (Object[])new Object[0]);
            }
            return;
        }
        if (r == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        String msg = this.readString();
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Got error '{}'", (Object[])new Object[]{msg});
        }
        if (r == 2) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"This is a serious error", (Object[])new Object[0]);
            }
            throw new IOException(msg);
        }
        throw new IOException("SCP returned an unexpected error: " + msg);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readFromRemote(String path) throws IOException {
        cmdParts = new String[3];
        this.writeOk();
        block29: while (this.session.isClosed() == false) {
            if (this.session.isRemoteEOF() != false) return;
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Waiting for command", (Object[])new Object[0]);
            }
            try {
                cmd = this.readString();
                this.exitCode = -2147483648;
            }
            catch (EOFException e) {
                return;
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Got command '{}'", (Object[])new Object[]{cmd});
            }
            cmdChar = cmd.charAt(0);
            switch (cmdChar) {
                case 'E': {
                    this.writeOk();
                    return;
                }
                case 'T': {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"SCP time not currently supported", (Object[])new Object[0]);
                    }
                    this.writeOk();
                    continue block29;
                }
                case 'C': 
                case 'D': {
                    this.parseCommand(cmd, cmdParts);
                    name = cmdParts[2];
                    targetAttr = null;
                    try {
                        targetAttr = this.nfs.getFileAttributes(path);
                    }
                    catch (FileNotFoundException ex) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"File {} not found", (Object[])new Object[]{path});
                        }
                    }
                    catch (PermissionDeniedException ex) {
                        if (!Log.isDebugEnabled()) ** GOTO lbl39
                        Log.debug((String)"File {} permission denied!", (Object[])new Object[]{path});
                    }
lbl39:
                    // 4 sources

                    if (cmdChar == 'D') {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Got directory request", (Object[])new Object[0]);
                        }
                        targetPath = path.equals(".") != false ? name : (targetAttr == null && this.firstPath != false ? path : path + (path.endsWith("/") != false ? "" : "/") + name);
                        this.firstPath = false;
                        try {
                            targetAttr = this.nfs.getFileAttributes(targetPath);
                        }
                        catch (FileNotFoundException ex) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"File {} not found", (Object[])new Object[]{targetPath});
                            }
                            targetAttr = null;
                        }
                        catch (PermissionDeniedException ex) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"File {} permission denied", (Object[])new Object[]{targetPath});
                            }
                            targetAttr = null;
                        }
                        if (targetAttr != null) {
                            if (!targetAttr.isDirectory()) {
                                msg = "Invalid target " + name + ", must be a directory";
                                this.writeError(msg);
                                throw new IOException(msg);
                            }
                        } else {
                            try {
                                if (Log.isDebugEnabled()) {
                                    Log.debug((String)"Creating directory {}", (Object[])new Object[]{targetPath});
                                }
                                if (!this.nfs.makeDirectory(targetPath, new SftpFileAttributes(2, this.getSession().getConnection().getContext().getPolicy(ScpPolicy.class).getSCPCharsetEncoding()))) {
                                    msg = "Could not create directory: " + name;
                                    this.writeError(msg);
                                    throw new IOException(msg);
                                }
                                targetAttr = this.nfs.getFileAttributes(targetPath);
                                if (Log.isDebugEnabled()) {
                                    Log.debug((String)"Setting permissions on directory", (Object[])new Object[0]);
                                }
                                targetAttr.setPermissionsFromMaskString(cmdParts[0]);
                            }
                            catch (FileNotFoundException e1) {
                                this.writeError("File not found");
                                throw new IOException("File not found");
                            }
                            catch (PermissionDeniedException e1) {
                                this.writeError("Permission denied");
                                throw new IOException("Permission denied");
                            }
                        }
                        this.readFromRemote(targetPath);
                        this.exitCode = 0;
                        continue block29;
                    }
                    targetPath = targetAttr == null || targetAttr.isDirectory() == false ? path : path + (path.endsWith("/") != false ? "" : "/") + name;
                    if (targetAttr == null) {
                        targetAttr = new SftpFileAttributes(1, "UTF-8");
                    }
                    targetAttr.setSize(new UnsignedInteger64(cmdParts[1]));
                    handle = null;
                    length = 0L;
                    started = new Date();
                    count = 0L;
                    con = this.session.getConnection();
                    this.fireEvent(new Event((Object)this, -16777146, true).addAttribute("FILE_NAME", targetPath).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("BYTES_EXPECTED", new Long(length)).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()).addAttribute("CONNECTION", con));
                    try {
                        targetPath = this.nfs.getRealPath(targetPath);
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Opening file for writing {}", (Object[])new Object[]{targetPath});
                        }
                        handle = this.nfs.openFile(targetPath, new UnsignedInteger32(26L), targetAttr);
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"NFS file opened", (Object[])new Object[0]);
                        }
                        this.writeOk();
                        length = Long.parseLong(cmdParts[1]);
                        this.fireEvent(new Event((Object)this, -16777150, true).addAttribute("FILE_NAME", targetPath).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("BYTES_EXPECTED", new Long(length)).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()).addAttribute("HANDLE", handle).addAttribute("CONNECTION", con));
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Reading from client", (Object[])new Object[0]);
                        }
                        if (this.filePolicy != null && this.filePolicy.hasUploadQuota()) {
                            if (!con.containsProperty("uploadQuota")) {
                                con.setProperty("uploadQuota", new Long(0L));
                            }
                            if ((quota = (Long)con.getProperty("uploadQuota")) + length > this.filePolicy.getConnectionUploadQuota()) {
                                this.writeError("User quota will be exceeded");
                                throw new IOException("User quota will be exceeded");
                            }
                            con.setProperty("uploadQuota", new Long(quota + length));
                        }
                        offset = new UnsignedInteger64(0L);
                        while (count < length) {
                            read = this.getInputStream().read(this.buffer, 0, (int)(length - count < (long)this.buffer.length ? length - count : (long)this.buffer.length));
                            if (read == -1) {
                                throw new EOFException("Scp received an unexpected EOF during file transfer");
                            }
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Got block of {} bytes", (Object[])new Object[]{read});
                            }
                            this.nfs.writeFile(handle, offset, this.buffer, 0, read);
                            offset = UnsignedInteger64.add((UnsignedInteger64)offset, (int)read);
                            count += (long)read;
                            if (!this.session.getConnection().getContext().getPolicy(ScpPolicy.class).isSCPReadWriteEvents()) continue;
                            this.fireEvent(new Event((Object)this, -16777147, true).addAttribute("CONNECTION", con).addAttribute("BYTES_TRANSFERED", new Long(count)).addAttribute("BYTES_WRITTEN", new Long(read)).addAttribute("FILE_NAME", targetPath).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("HANDLE", handle).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()));
                        }
                        this.fireEvent(new Event((Object)this, -16777152, true).addAttribute("FILE_NAME", targetPath).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("BYTES_TRANSFERED", new Long(count)).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()).addAttribute("HANDLE", handle).addAttribute("CONNECTION", con));
                        if (handle != null) {
                        }
                        ** GOTO lbl162
                    }
                    catch (InvalidHandleException ex) {
                        try {
                            this.writeError("Invalid handle.");
                            this.fireUploadErrorEvent(handle, targetPath, started, count, ex, con);
                            throw new IOException("Invalid handle.");
                            catch (FileNotFoundException ex) {
                                this.writeError("File not found");
                                this.fireUploadErrorEvent(handle, targetPath, started, count, ex, con);
                                throw new IOException("File not found");
                            }
                            catch (PermissionDeniedException ex) {
                                this.writeError("Permission denied");
                                this.fireUploadErrorEvent(handle, targetPath, started, count, ex, con);
                                throw new IOException("Permission denied");
                            }
                            catch (Throwable ex) {
                                this.writeError("Received exception during transfer to file system. " + ex.getMessage());
                                this.fireUploadErrorEvent(handle, targetPath, started, count, ex, con);
                                throw new IOException(ex.getMessage(), ex);
                            }
                        }
                        catch (Throwable var17_28) {
                            if (handle == null) throw var17_28;
                            try {
                                if (Log.isDebugEnabled()) {
                                    Log.debug((String)"Closing handle", (Object[])new Object[0]);
                                }
                                this.nfs.closeFile(handle);
                                throw var17_28;
                            }
                            catch (Exception var18_29) {
                                // empty catch block
                            }
                            throw var17_28;
                        }
                    }
                    try {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Closing handle", (Object[])new Object[0]);
                        }
                        this.nfs.closeFile(handle);
                    }
                    catch (Exception read) {}
lbl162:
                    // 3 sources

                    this.waitForResponse();
                    if (this.preserveAttributes) {
                        targetAttr.setPermissionsFromMaskString(cmdParts[0]);
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Setting permissions on directory to {}", (Object[])new Object[]{targetAttr.getPermissionsString()});
                        }
                        try {
                            this.nfs.setFileAttributes(targetPath, targetAttr);
                        }
                        catch (Exception e) {
                            this.writeError("Failed to set file permissions.");
                            continue block29;
                        }
                    }
                    this.writeOk();
                    this.exitCode = 0;
                    continue block29;
                }
            }
        }
        return;
        this.writeError("Unexpected cmd: " + cmd);
        throw new IOException("SCP unexpected cmd: " + cmd);
    }

    private void fireUploadErrorEvent(byte[] handle, String targetPath, Date started, long count, Throwable ex, SshConnection con) {
        this.fireEvent(new Event((Object)this, -16777152, ex).addAttribute("FILE_NAME", targetPath).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("BYTES_TRANSFERED", new Long(count)).addAttribute("FILE_FACTORY", this.nfs.getFileFactory()).addAttribute("HANDLE", handle).addAttribute("CONNECTION", con));
    }

    private void parseCommand(String cmd, String[] cmdParts) throws IOException {
        int l = cmd.indexOf(32);
        int r = cmd.indexOf(32, l + 1);
        if (l == -1 || r == -1) {
            this.writeError("Syntax error in cmd");
            throw new IOException("Syntax error in cmd");
        }
        cmdParts[0] = cmd.substring(1, l);
        cmdParts[1] = cmd.substring(l + 1, r);
        cmdParts[2] = cmd.substring(r + 1);
    }

    private String readString() throws IOException {
        int ch;
        int i = 0;
        while ((ch = this.getInputStream().read()) != 10 && ch >= 0) {
            this.buffer[i++] = (byte)ch;
        }
        if (ch == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        if (this.buffer[0] == 10) {
            throw new IOException("Unexpected <NL>");
        }
        if (this.buffer[0] == 2 || this.buffer[0] == 1) {
            String msg = new String(this.buffer, 1, i - 1);
            if (this.buffer[0] == 2) {
                throw new IOException(msg);
            }
            throw new IOException("SCP returned an unexpected error: " + msg);
        }
        return new String(this.buffer, 0, i);
    }
}

