/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.auth;

import com.sshtools.common.auth.KeyboardInteractiveProvider;
import com.sshtools.common.auth.PasswordAuthenticationProvider;
import com.sshtools.common.auth.PasswordChangeException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh2.KBIPrompt;
import java.io.IOException;
import java.util.Collection;

public class PasswordKeyboardInteractiveProvider
implements KeyboardInteractiveProvider {
    static final int REQUESTED_PASSWORD = 1;
    static final int CHANGING_PASSWORD = 2;
    static final int FINISHED = 2;
    String username;
    String password;
    boolean success = false;
    String name = "password";
    String instruction = "";
    SshConnection con;
    PasswordAuthenticationProvider[] providers;
    int state = 1;
    int maxAttempts = 2;
    PasswordAuthenticationProvider selectedProvider = null;

    public PasswordKeyboardInteractiveProvider() {
    }

    public PasswordKeyboardInteractiveProvider(PasswordAuthenticationProvider[] providers, SshConnection con) {
        this.providers = providers;
        this.con = con;
    }

    @Override
    public boolean hasAuthenticated() {
        return this.success;
    }

    @Override
    public boolean setResponse(String[] answers, Collection<KBIPrompt> additionalPrompts) {
        if (answers.length == 0) {
            throw new RuntimeException("Not enough answers!");
        }
        --this.maxAttempts;
        if (this.maxAttempts < 0) {
            this.state = 2;
            return false;
        }
        switch (this.state) {
            case 1: {
                this.password = answers[0];
                try {
                    PasswordAuthenticationProvider[] passwordAuthenticationProviderArray = this.providers;
                    int n = passwordAuthenticationProviderArray.length;
                    for (int i = 0; i < n; ++i) {
                        PasswordAuthenticationProvider passwordProvider;
                        this.selectedProvider = passwordProvider = passwordAuthenticationProviderArray[i];
                        this.success = passwordProvider.verifyPassword(this.con, this.username, this.password);
                        if (!this.success) continue;
                        this.state = 2;
                        return true;
                    }
                    this.instruction = "Sorry, try again";
                    additionalPrompts.add(new KBIPrompt(this.getPasswordPrompt(), false));
                    return false;
                }
                catch (PasswordChangeException e) {
                    this.state = 2;
                    this.maxAttempts = 2;
                    additionalPrompts.add(new KBIPrompt(this.getNewPasswordPrompt(), false));
                    additionalPrompts.add(new KBIPrompt(this.getConfirmPasswordPrompt(), false));
                    this.instruction = e.getMessage() == null ? this.getChangePasswordInstructions(this.username) : e.getMessage();
                    return true;
                }
                catch (IOException ex) {
                    this.con.disconnect(11, ex.getMessage());
                }
            }
            case 2: {
                if (answers.length < 2) {
                    throw new RuntimeException("Not enough answers!");
                }
                String password1 = answers[0];
                String password2 = answers[1];
                if (password1.equals(password2)) {
                    try {
                        this.success = this.selectedProvider.changePassword(this.con, this.username, this.password, password1);
                        if (this.success) {
                            this.state = 2;
                            return true;
                        }
                    }
                    catch (PasswordChangeException passwordChangeException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.state = 2;
                    additionalPrompts.add(new KBIPrompt(this.getNewPasswordPrompt(), false));
                    additionalPrompts.add(new KBIPrompt(this.getConfirmPasswordPrompt(), false));
                    this.instruction = this.getChangePasswordFailed(this.username);
                    return true;
                }
                this.instruction = this.getChangePasswordMismatch(this.username);
                additionalPrompts.add(new KBIPrompt(this.getNewPasswordPrompt(), false));
                additionalPrompts.add(new KBIPrompt(this.getConfirmPasswordPrompt(), false));
                return true;
            }
        }
        throw new RuntimeException("We shouldn't be here");
    }

    @Override
    public KBIPrompt[] init(SshConnection con) {
        this.username = con.getUsername();
        this.con = con;
        KBIPrompt[] prompts = new KBIPrompt[]{new KBIPrompt(this.getPasswordPrompt(), false)};
        this.instruction = this.getInstructions(this.username);
        return prompts;
    }

    @Override
    public String getInstruction() {
        return this.instruction;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getPasswordPrompt() {
        return "Password:";
    }

    protected String getConfirmPasswordPrompt() {
        return "Confirm Password:";
    }

    protected String getNewPasswordPrompt() {
        return "New Password:";
    }

    protected String getInstructions(String username) {
        return "Enter password for " + username;
    }

    protected String getChangePasswordInstructions(String username) {
        return "Enter new password for " + username;
    }

    protected String getChangePasswordFailed(String username) {
        return "Password change failed! Enter new password for " + username;
    }

    protected String getChangePasswordMismatch(String username) {
        return "Passwords do not match! Enter new password for " + username;
    }
}

