/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.policy;

import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.permissions.Permissions;
import com.sshtools.common.policy.FileFactory;
import com.sshtools.common.sftp.SftpExtension;
import com.sshtools.common.sftp.SftpExtensionFactory;
import com.sshtools.common.sftp.extensions.DefaultSftpExtensionFactory;
import com.sshtools.common.ssh.SshConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class FileSystemPolicy
extends Permissions {
    long connectionUploadQuota = -1L;
    FileFactory fileFactory;
    String sftpCharsetEncoding = "UTF-8";
    boolean allowZeroLengthFileUpload = true;
    boolean sftpVersion4Enabled = true;
    int sftpVersion = 4;
    boolean sftpReadWriteEvents = false;
    boolean scpReadWriteEvents = false;
    int maxConcurrentTransfers = 50;
    int maximumSftpRequests = 10;
    String sftpLongnameDateFormat = "MMM dd  yyyy";
    String sftpLongnameDateFormatWithTime = "MMM dd HH:mm";
    List<SftpExtensionFactory> sftpExtensionFactories = new ArrayList<SftpExtensionFactory>();
    boolean closeFileBeforeFailedTransferEvents = false;
    boolean mkdirParentMustExist = true;
    private int sftpMaxPacketSize = 65536;
    private int sftpMaxWindowSize = 1024000;
    private int sftpMinWindowSize = 131072;

    public FileSystemPolicy() {
        this.sftpExtensionFactories.add(new DefaultSftpExtensionFactory());
    }

    public long getConnectionUploadQuota() {
        return this.connectionUploadQuota;
    }

    public void setConnectionUploadQuota(long connectionUploadQuota) {
        this.connectionUploadQuota = connectionUploadQuota;
    }

    public boolean hasUploadQuota() {
        return this.connectionUploadQuota > -1L;
    }

    public String getSFTPCharsetEncoding() {
        return this.sftpCharsetEncoding;
    }

    public void setSFTPCharsetEncoding(String sftpCharsetEncoding) {
        this.sftpCharsetEncoding = sftpCharsetEncoding;
    }

    public void setFileFactory(FileFactory fileFactory) {
        this.fileFactory = new CachingFileFactory(fileFactory);
    }

    public FileFactory getFileFactory() {
        return this.fileFactory;
    }

    public boolean isAllowZeroLengthFileUpload() {
        return this.allowZeroLengthFileUpload;
    }

    public void setAllowZeroLengthFileUpload(boolean allowZeroLengthFileUpload) {
        this.allowZeroLengthFileUpload = allowZeroLengthFileUpload;
    }

    public void setMaxConcurrentTransfers(int maxConcurrentTransfers) {
        this.maxConcurrentTransfers = maxConcurrentTransfers;
    }

    public int getMaxConcurrentTransfers() {
        return this.maxConcurrentTransfers;
    }

    public void setSupportedSFTPVersion(int sftpVersion) {
        if (sftpVersion < 1 || sftpVersion > 4) {
            throw new IllegalArgumentException("SFTP version must be between 1 and 4");
        }
        this.sftpVersion = sftpVersion;
    }

    public int getSFTPVersion() {
        return this.sftpVersion;
    }

    public void setSFTPReadWriteEvents(boolean sftpReadWriteEvents) {
        this.sftpReadWriteEvents = sftpReadWriteEvents;
    }

    public boolean isSFTPReadWriteEvents() {
        return this.sftpReadWriteEvents;
    }

    public void setSCPReadWriteEvents(boolean scpReadWriteEvents) {
        this.scpReadWriteEvents = scpReadWriteEvents;
    }

    public boolean isSCPReadWriteEvents() {
        return this.scpReadWriteEvents;
    }

    public int getMaximumNumberOfAsyncSFTPRequests() {
        return this.maximumSftpRequests;
    }

    public void setMaximumNumberofAsyncSFTPRequests(int maximumSftpRequests) {
        this.maximumSftpRequests = maximumSftpRequests;
    }

    public String getSFTPLongnameDateFormat() {
        return this.sftpLongnameDateFormat;
    }

    public String getSFTPLongnameDateFormatWithTime() {
        return this.sftpLongnameDateFormatWithTime;
    }

    public SftpExtension getSFTPExtension(String requestName) {
        for (SftpExtensionFactory factory : this.sftpExtensionFactories) {
            if (!factory.getSupportedExtensions().contains(requestName)) continue;
            return factory.getExtension(requestName);
        }
        return null;
    }

    public Collection<SftpExtensionFactory> getSFTPExtensionFactories() {
        return this.sftpExtensionFactories;
    }

    public boolean isSFTPCloseFileBeforeFailedTransferEvents() {
        return this.closeFileBeforeFailedTransferEvents;
    }

    public void setSFTPCloseFileBeforeFailedTransferEvents(boolean closeFileBeforeFailedTransferEvents) {
        this.closeFileBeforeFailedTransferEvents = closeFileBeforeFailedTransferEvents;
    }

    public int getSftpMaxPacketSize() {
        return this.sftpMaxPacketSize;
    }

    public void setSftpMaxPacketSize(int sftpMaxPacketSize) {
        this.sftpMaxPacketSize = sftpMaxPacketSize;
    }

    public int getSftpMaxWindowSize() {
        return this.sftpMaxWindowSize;
    }

    public void setSftpMaxWindowSize(int sftpMaxWindowSize) {
        this.sftpMaxWindowSize = sftpMaxWindowSize;
    }

    public int getSftpMinWindowSize() {
        return this.sftpMinWindowSize;
    }

    public void setSftpMinWindowSize(int sftpMinWindowSize) {
        this.sftpMinWindowSize = sftpMinWindowSize;
    }

    public void setMkdirParentMustExist(boolean mkdirParentMustExist) {
        this.mkdirParentMustExist = mkdirParentMustExist;
    }

    public boolean isMkdirParentMustExist() {
        return this.mkdirParentMustExist;
    }

    class CachingFileFactory
    implements FileFactory {
        AbstractFileFactory<?> ff = null;
        FileFactory fileFactory;

        CachingFileFactory(FileFactory fileFactory) {
            this.fileFactory = fileFactory;
        }

        @Override
        public AbstractFileFactory<?> getFileFactory(SshConnection con) throws IOException, PermissionDeniedException {
            if (Objects.nonNull(this.ff)) {
                return this.ff;
            }
            this.ff = this.fileFactory.getFileFactory(con);
            return this.ff;
        }
    }
}

