/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.knownhosts;

import com.sshtools.common.knownhosts.KnownHostsKeyVerification;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class KnownHostsFile
extends KnownHostsKeyVerification {
    File file;

    public KnownHostsFile(File file) throws SshException {
        this.file = file;
        try (FileInputStream in = new FileInputStream(file);){
            this.load(in);
        }
        catch (IOException e) {
            throw new SshException(e);
        }
    }

    public void store() throws IOException {
        IOUtils.writeStringToFile((File)this.file, (String)this.toString(), (String)"UTF-8");
    }

    public File getKnownHostsFile() {
        return this.file;
    }

    @Override
    public boolean isHostFileWriteable() {
        return this.file.canWrite();
    }

    public KnownHostsFile() throws SshException {
        this(new File(new File(System.getProperty("user.home"), ".ssh"), "known_hosts"));
    }

    @Override
    protected void onInvalidHostEntry(String entry) throws SshException {
    }

    @Override
    protected void onHostKeyMismatch(String host, List<SshPublicKey> allowedHostKey, SshPublicKey actualHostKey) throws SshException {
    }

    @Override
    protected void onUnknownHost(String host, SshPublicKey key) throws SshException {
    }

    @Override
    protected void onRevokedKey(String host, SshPublicKey key) {
    }

    @Override
    protected void onHostKeyUpdated(Set<String> names, SshPublicKey key) {
        this.save();
    }

    @Override
    protected void onHostKeyAdded(Set<String> names, SshPublicKey key) {
        this.save();
    }

    @Override
    protected void onHostKeyRemoved(Set<String> names, SshPublicKey key) {
        this.save();
    }

    protected void save() {
        try {
            this.store();
        }
        catch (IOException e) {
            Log.error((String)"Failed to store known_hosts file", (Throwable)e, (Object[])new Object[0]);
        }
    }
}

