/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.auth;

import com.sshtools.common.auth.AbstractAuthenticationProtocol;
import com.sshtools.common.auth.AuthenticationMechanism;
import com.sshtools.common.auth.PublicKeyAuthenticationProvider;
import com.sshtools.common.logger.Log;
import com.sshtools.common.policy.AuthenticationPolicy;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.sshd.AbstractServerTransport;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class PublicKeyAuthentication<C extends Context>
implements AuthenticationMechanism {
    public static final int SSH_MSG_USERAUTH_PK_OK = 60;
    AbstractServerTransport<C> transport;
    AbstractAuthenticationProtocol<C> authentication;
    SshConnection con;
    PublicKeyAuthenticationProvider[] providers;
    public static final String AUTHENTICATION_METHOD = "publickey";

    public PublicKeyAuthentication(AbstractServerTransport<C> transport, AbstractAuthenticationProtocol<C> authentication, SshConnection con, PublicKeyAuthenticationProvider[] providers) {
        this.transport = transport;
        this.authentication = authentication;
        this.con = con;
        this.providers = providers;
    }

    @Override
    public String getMethod() {
        return AUTHENTICATION_METHOD;
    }

    @Override
    public boolean startRequest(String username, byte[] msg) throws IOException {
        this.transport.addTask(ExecutorOperationSupport.EVENTS, new PublicKeyAuthenticationTask(this.con, username, msg));
        return true;
    }

    private SshPublicKey lookupAuthorizedKey(String algorithm, byte[] keyblob, SshConnection con, InetAddress remoteAddress, boolean verify) {
        try {
            SshPublicKey key = SshPublicKeyFileFactory.decodeSSH2PublicKey(algorithm, keyblob);
            if (con.getProperty(key.getFingerprint()) != null) {
                return key;
            }
            if (this.providers != null) {
                for (PublicKeyAuthenticationProvider provider : this.providers) {
                    if (!provider.checkKey(key, con)) continue;
                    con.setProperty(key.getFingerprint(), key);
                    return key;
                }
            }
            return null;
        }
        catch (IOException ex) {
            if (Log.isDebugEnabled()) {
                Log.error((String)"Failed to lookup authorized key", (Throwable)ex, (Object[])new Object[0]);
            }
            this.transport.disconnect(11, ex.getMessage());
            return null;
        }
        catch (SshException ex) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Client provided unreadable key for authentication", (Throwable)ex, (Object[])new Object[0]);
            }
            return null;
        }
    }

    @Override
    public boolean processMessage(byte[] msg) throws IOException {
        return false;
    }

    class PublicKeyAuthenticationTask
    extends ConnectionAwareTask {
        String username;
        byte[] msg;

        PublicKeyAuthenticationTask(SshConnection con, String username, byte[] msg) {
            super(con);
            this.username = username;
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doTask() {
            block22: {
                try (ByteArrayReader bar = new ByteArrayReader(this.msg);){
                    boolean verify = bar.read() != 0;
                    final String algorithm = bar.readString();
                    if (!PublicKeyAuthentication.this.transport.getContext().getComponentManager().supportedPublicKeys().contains(algorithm)) {
                        PublicKeyAuthentication.this.authentication.failedAuthentication();
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Unsupported public key algorithm", (Object[])new Object[0]);
                        }
                        return;
                    }
                    final byte[] keyblob = bar.readBinaryString();
                    byte[] signature = null;
                    if (verify) {
                        signature = bar.readBinaryString();
                        SshPublicKey key = PublicKeyAuthentication.this.lookupAuthorizedKey(algorithm, keyblob, this.con, this.con.getRemoteAddress(), verify);
                        if (key != null) {
                            try (ByteArrayWriter baw = new ByteArrayWriter();){
                                baw.writeBinaryString(PublicKeyAuthentication.this.transport.getSessionKey());
                                baw.write(50);
                                baw.writeString(this.username);
                                baw.writeString("ssh-connection");
                                baw.writeString(PublicKeyAuthentication.AUTHENTICATION_METHOD);
                                baw.write(1);
                                baw.writeString(algorithm);
                                baw.writeBinaryString(keyblob);
                                byte[] data = baw.toByteArray();
                                if (key.verifySignature(signature, data)) {
                                    PublicKeyAuthentication.this.authentication.completedAuthentication();
                                } else {
                                    PublicKeyAuthentication.this.authentication.failedAuthentication();
                                }
                                break block22;
                            }
                        }
                        PublicKeyAuthentication.this.authentication.failedAuthentication();
                        break block22;
                    }
                    Integer count = (Integer)this.con.getProperty("publickey.max.verify");
                    count = count == null ? new Integer(1) : new Integer(count + 1);
                    this.con.setProperty("publickey.max.verify", count);
                    if (count > PublicKeyAuthentication.this.transport.getContext().getPolicy(AuthenticationPolicy.class).getMaximumPublicKeyVerificationAttempts()) {
                        PublicKeyAuthentication.this.transport.disconnect(14, "Too many publickey verification attempts were made.");
                        return;
                    }
                    if (PublicKeyAuthentication.this.lookupAuthorizedKey(algorithm, keyblob, this.con, this.con.getRemoteAddress(), verify) != null) {
                        PublicKeyAuthentication.this.authentication.discardAuthentication();
                        PublicKeyAuthentication.this.transport.postMessage(new SshMessage(){

                            @Override
                            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                                buf.put((byte)60);
                                buf.putInt(algorithm.length());
                                buf.put(algorithm.getBytes());
                                buf.putInt(keyblob.length);
                                buf.put(keyblob);
                                return true;
                            }

                            @Override
                            public void messageSent(Long sequenceNo) {
                                if (Log.isDebugEnabled()) {
                                    Log.debug((String)"Sent SSH_MSG_USERAUTH_PK_OK", (Object[])new Object[0]);
                                }
                            }
                        });
                    } else {
                        PublicKeyAuthentication.this.authentication.failedAuthentication(false, !PublicKeyAuthentication.this.transport.getContext().getPolicy(AuthenticationPolicy.class).isPublicKeyVerificationFailedAuth());
                    }
                }
            }
        }
    }
}

