/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshKeyFingerprint;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshRsaPublicKey;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class Ssh2RsaPublicKey
implements SshRsaPublicKey {
    protected RSAPublicKey pubKey;

    public Ssh2RsaPublicKey() {
    }

    public Ssh2RsaPublicKey(RSAPublicKey pubKey) {
        this.pubKey = pubKey;
    }

    public Ssh2RsaPublicKey(BigInteger modulus, BigInteger publicExponent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
        this.pubKey = (RSAPublicKey)keyFactory.generatePublic(spec);
    }

    @Override
    public SecurityLevel getSecurityLevel() {
        return SecurityLevel.WEAK;
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public byte[] getEncoded() throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeString(this.getEncodingAlgorithm());
            baw.writeBigInteger(this.pubKey.getPublicExponent());
            baw.writeBigInteger(this.pubKey.getModulus());
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new SshException("Failed to encoded key data", 5, ex);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    @Override
    public int getBitLength() {
        return this.pubKey.getModulus().bitLength();
    }

    @Override
    public String getEncodingAlgorithm() {
        return this.getAlgorithm();
    }

    @Override
    public void init(byte[] blob, int start, int len) throws SshException {
        try (ByteArrayReader bar = new ByteArrayReader(blob, start, len);){
            String header = bar.readString();
            if (!header.equals(this.getEncodingAlgorithm())) {
                throw new SshException("The encoded key is not " + this.getEncodingAlgorithm(), 5);
            }
            BigInteger e = bar.readBigInteger();
            BigInteger n = bar.readBigInteger();
            RSAPublicKeySpec rsaKey = new RSAPublicKeySpec(n, e);
            try {
                KeyFactory kf = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
                this.pubKey = (RSAPublicKey)kf.generatePublic(rsaKey);
            }
            catch (Exception ex) {
                throw new SshException("Failed to obtain RSA key instance from JCE", 5, ex);
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return "ssh-rsa";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifySignature(byte[] signature, byte[] data) throws SshException {
        try {
            String signatureAlgorithm = "ssh-rsa";
            try (ByteArrayReader bar = new ByteArrayReader(signature);){
                long count = bar.readInt();
                if (count > 0L && count < 100L) {
                    bar.reset();
                    byte[] sig = bar.readBinaryString();
                    signatureAlgorithm = new String(sig);
                    signature = bar.readBinaryString();
                }
            }
            return this.verifyJCESignature(signature, signatureAlgorithm, data, true);
        }
        catch (Exception ex) {
            throw new SshException(16, (Throwable)ex);
        }
    }

    public int getSignatureLength() {
        int length = this.getModulus().bitLength() / 8;
        int mod = this.getModulus().bitLength() % 8;
        if (mod != 0) {
            ++length;
        }
        return length;
    }

    private boolean verifyJCESignature(byte[] signature, String signatureAlgorithm, byte[] data, boolean allowCorrect) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        boolean result;
        byte[] original;
        boolean corrected;
        int signatureLength;
        int expectedLength;
        block16: {
            Signature s;
            switch (signatureAlgorithm) {
                case "rsa-sha2-256": {
                    s = JCEProvider.getProviderForAlgorithm("SHA256WithRSA") == null ? Signature.getInstance("SHA256WithRSA") : Signature.getInstance("SHA256WithRSA", JCEProvider.getProviderForAlgorithm("SHA256WithRSA"));
                    break;
                }
                case "rsa-sha2-512": {
                    s = JCEProvider.getProviderForAlgorithm("SHA512WithRSA") == null ? Signature.getInstance("SHA512WithRSA") : Signature.getInstance("SHA512WithRSA", JCEProvider.getProviderForAlgorithm("SHA512WithRSA"));
                    break;
                }
                default: {
                    s = JCEProvider.getProviderForAlgorithm("SHA1WithRSA") == null ? Signature.getInstance("SHA1WithRSA") : Signature.getInstance("SHA1WithRSA", JCEProvider.getProviderForAlgorithm("SHA1WithRSA"));
                }
            }
            s.initVerify(this.pubKey);
            s.update(data);
            expectedLength = this.getSignatureLength();
            signatureLength = signature.length;
            corrected = false;
            original = signature;
            if (allowCorrect && signature.length < expectedLength) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("No Padding Detected: Expected signature length of " + expectedLength + " (modulus=" + this.getModulus().bitLength() + ") but got " + signature.length), (Object[])new Object[0]);
                }
                byte[] tmp = new byte[expectedLength];
                System.arraycopy(signature, 0, tmp, expectedLength - signature.length, signature.length);
                signature = tmp;
                corrected = true;
            }
            result = false;
            try {
                result = s.verify(signature);
            }
            catch (SignatureException e) {
                if (!allowCorrect) {
                    throw e;
                }
                if (!Log.isDebugEnabled()) break block16;
                Log.debug((String)"Signature failed. Falling back to raw signature data.", (Object[])new Object[0]);
            }
        }
        if (!result) {
            if (corrected) {
                result = this.verifyJCESignature(original, signatureAlgorithm, data, false);
            }
            if (!result && Log.isDebugEnabled() && Boolean.getBoolean("maverick.verbose")) {
                Log.debug((String)("JCE Reports Invalid Signature: Expected signature length of " + expectedLength + " (modulus=" + this.getModulus().bitLength() + ") but got " + signatureLength), (Object[])new Object[0]);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshRsaPublicKey) {
            try {
                return ((SshPublicKey)obj).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException ex) {
            return 0;
        }
    }

    @Override
    public BigInteger doPublic(BigInteger input) throws SshException {
        try {
            Cipher cipher = JCEProvider.getProviderForAlgorithm("RSA") == null ? Cipher.getInstance("RSA") : Cipher.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            cipher.init(1, (Key)this.pubKey, JCEProvider.getSecureRandom());
            byte[] tmp = input.toByteArray();
            return new BigInteger(cipher.doFinal(tmp, tmp[0] == 0 ? 1 : 0, tmp[0] == 0 ? tmp.length - 1 : tmp.length));
        }
        catch (Throwable e) {
            if (e.getMessage().indexOf("RSA") > -1) {
                throw new SshException("JCE provider requires BouncyCastle provider for RSA/NONE/PKCS1Padding component. Add bcprov.jar to your classpath or configure an alternative provider for this algorithm", 5);
            }
            throw new SshException(e);
        }
    }

    @Override
    public BigInteger getModulus() {
        return this.pubKey.getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.pubKey.getPublicExponent();
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public PublicKey getJCEPublicKey() {
        return this.pubKey;
    }

    @Override
    public String test() {
        try {
            KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            Cipher cipher = JCEProvider.getProviderForAlgorithm("RSA") == null ? Cipher.getInstance("RSA") : Cipher.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            Signature s = JCEProvider.getProviderForAlgorithm("SHA1WithRSA") == null ? Signature.getInstance("SHA1WithRSA") : Signature.getInstance("SHA1WithRSA", JCEProvider.getProviderForAlgorithm("SHA1WithRSA"));
            return keyFactory.getProvider().getName();
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public String getSigningAlgorithm() {
        return "ssh-rsa";
    }
}

