/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.permissions;

import com.sshtools.common.logger.Log;
import com.sshtools.common.net.CIDRNetwork;
import com.sshtools.common.permissions.Permissions;
import com.sshtools.common.util.ExpiringConcurrentHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class IPPolicy
extends Permissions {
    static final int ALLOW_CONNECT = 1;
    List<CIDRNetwork> blacklist = new ArrayList<CIDRNetwork>();
    List<CIDRNetwork> whitelist = new ArrayList<CIDRNetwork>();
    ExpiringConcurrentHashMap<InetAddress, Integer> flaggedAddressCounts;
    int failedAuthenticationThreshold = 15;
    ExpiringConcurrentHashMap<InetAddress, Boolean> temporaryBans = new ExpiringConcurrentHashMap(TimeUnit.HOURS.toMillis(5L));

    public IPPolicy() {
        this.add(1);
        this.setFailedAuthenticationThresholdPeriod(5L, TimeUnit.MINUTES);
    }

    public void setFailedAuthenticationCountThreshold(int failedAuthenticationThreshold) {
        this.failedAuthenticationThreshold = failedAuthenticationThreshold;
    }

    public void setFailedAuthenticationThresholdPeriod(long failedAuthenticationThresholdPeriod, TimeUnit timeUnit) {
        this.flaggedAddressCounts = new ExpiringConcurrentHashMap(timeUnit.toMillis(failedAuthenticationThresholdPeriod));
    }

    protected boolean assertConnection(SocketAddress remoteAddress, SocketAddress localAddress) {
        if (this.check(1)) {
            return this.assertAllowed(remoteAddress, localAddress);
        }
        return false;
    }

    protected boolean assertAllowed(SocketAddress remoteAddress, SocketAddress localAddress) {
        try {
            boolean allowed = true;
            InetAddress resolved = ((InetSocketAddress)remoteAddress).getAddress();
            Boolean temporarilyBanned = (Boolean)this.temporaryBans.getOrDefault((Object)resolved, (Object)false);
            if (temporarilyBanned.booleanValue()) {
                Log.info((String)"Rejecting IP {} because of temporary ban", (Object[])new Object[]{resolved.getHostAddress()});
                return false;
            }
            String addr = resolved.getHostAddress();
            if (!this.whitelist.isEmpty()) {
                allowed = this.isListed(addr, this.whitelist);
            }
            boolean rejected = this.isListed(addr, this.blacklist);
            if (Log.isTraceEnabled()) {
                Log.trace((String)"{} is {} by IP policy", (Object[])new Object[]{remoteAddress.toString(), allowed && !rejected ? "allowed" : "denied"});
            }
            return allowed && !rejected;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP range");
        }
    }

    protected boolean isListed(String addr, List<CIDRNetwork> values) throws UnknownHostException {
        for (CIDRNetwork value : values) {
            if (!value.isValidAddressForNetwork(addr)) continue;
            return true;
        }
        return false;
    }

    public void flagAddress(InetAddress addr) {
        Integer count = (Integer)this.flaggedAddressCounts.getOrDefault((Object)addr, (Object)0);
        if (count >= this.failedAuthenticationThreshold) {
            Log.info((String)"Temporarily banning IP address {} due to failed authentication count of {}", (Object[])new Object[]{addr.getHostAddress(), count});
            this.temporaryBans.put((Object)addr, (Object)true);
            return;
        }
        count = count + 1;
        Log.info((String)"Flagging IP address {} with failed authentication count of {}", (Object[])new Object[]{addr.getHostAddress(), count});
        this.flaggedAddressCounts.put((Object)addr, (Object)count);
    }

    public final boolean checkConnection(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.assertConnection(remoteAddress, localAddress);
    }

    public void stopAcceptingConnections() {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Stop accepting connections on IP Policy", (Object[])new Object[0]);
        }
        this.remove(1);
    }

    public void startAcceptingConnections() {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Start accepting connections on IP Policy", (Object[])new Object[0]);
        }
        this.add(1);
    }

    public void blacklist(String addr) throws UnknownHostException {
        Log.info((String)"Blacklisting IP address {}", (Object[])new Object[]{addr});
        this.blacklist.add(new CIDRNetwork(addr));
    }

    public void whitelist(String addr) throws UnknownHostException {
        Log.info((String)"Whitelisting IP address {}", (Object[])new Object[]{addr});
        this.whitelist.add(new CIDRNetwork(addr));
    }
}

