/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.IncompatibleAlgorithm;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SecurityPolicy;
import com.sshtools.common.util.Utils;

public class DefaultSecurityPolicy
implements SecurityPolicy {
    SecurityLevel minimumSecurity;
    boolean managedSecurity;

    public DefaultSecurityPolicy(SecurityLevel minimumSecurity, boolean managedSecurity) {
        this.minimumSecurity = minimumSecurity;
        this.managedSecurity = managedSecurity;
    }

    @Override
    public SecurityLevel getMinimumSecurityLevel() {
        return this.minimumSecurity;
    }

    @Override
    public boolean isManagedSecurity() {
        return this.managedSecurity;
    }

    @Override
    public boolean isDropSecurityAsLastResort() {
        return false;
    }

    @Override
    public void onIncompatibleSecurity(String host, int port, String remoteIdentification, IncompatibleAlgorithm ... reports) {
        Log.error((String)"Connection to {}:{} could not be established due to incompatible security protocols", (Object[])new Object[]{host, port});
        Log.error((String)"The remote host identified itself as {}", (Object[])new Object[]{remoteIdentification});
        Log.error((String)"The following algorithms could not be negotiated:", (Object[])new Object[0]);
        for (IncompatibleAlgorithm report : reports) {
            Log.error((String)"{} could not be negotiated from remote algorithms {}", (Object[])new Object[]{report.getType().name(), Utils.csv((String[])report.getRemoteAlgorithms())});
        }
    }
}

