/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.sftp.SftpExtension;
import com.sshtools.common.sftp.SftpExtensionFactory;
import com.sshtools.common.sftp.extensions.CopyFileSftpExtension;
import com.sshtools.common.sftp.extensions.MD5FileExtension;
import com.sshtools.common.sftp.extensions.MD5HandleExtension;
import com.sshtools.common.sftp.extensions.PosixRenameExtension;
import com.sshtools.common.sftp.extensions.SupportedSftpExtensions;
import com.sshtools.common.sftp.extensions.filter.OpenDirectoryWithFilterExtension;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultSftpExtensionFactory
implements SftpExtensionFactory {
    Map<String, SftpExtension> extensions = new HashMap<String, SftpExtension>();

    public DefaultSftpExtensionFactory() {
    }

    public DefaultSftpExtensionFactory(SupportedSftpExtensions ... supportedExtensions) {
        List<SupportedSftpExtensions> supported = Arrays.asList(supportedExtensions);
        if (supported.contains((Object)SupportedSftpExtensions.MD5_FILE_HASH)) {
            this.extensions.put("md5-hash", new MD5FileExtension());
            this.extensions.put("md5-hash-handle", new MD5HandleExtension());
        }
        if (supported.contains((Object)SupportedSftpExtensions.POSIX_RENAME)) {
            this.extensions.put("posix-rename@openssh.com", new PosixRenameExtension());
        }
        if (supported.contains((Object)SupportedSftpExtensions.COPY_FILE)) {
            this.extensions.put("copy-file", new CopyFileSftpExtension());
        }
        if (supported.contains((Object)SupportedSftpExtensions.OPEN_DIRECTORY_WITH_FILTER)) {
            this.extensions.put("open-directory-with-filter@sshtools.com", new OpenDirectoryWithFilterExtension());
        }
    }

    @Override
    public SftpExtension getExtension(String requestName) {
        return this.extensions.get(requestName);
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }

    @Override
    public Collection<SftpExtension> getExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }
}

