/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.publickey;

import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.Base64EncodedFileFormat;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.OpenSSHPrivateKeyFile;
import com.sshtools.common.publickey.PuTTYPrivateKeyFile;
import com.sshtools.common.publickey.SSHCOMPrivateKeyFile;
import com.sshtools.common.publickey.Ssh1RsaPrivateKeyFile;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.publickey.SshtoolsPrivateKeyFile;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SshPrivateKeyFileFactory {
    public static final int OPENSSH_FORMAT = 0;
    public static final int OPENSSL_FORMAT = 4;

    public static SshPrivateKeyFile parse(byte[] formattedkey) throws IOException {
        block13: {
            if (JCEProvider.hasBCProvider() && JCEProvider.isBCEnabled()) {
                try {
                    Class<?> clz = Class.forName("com.sshtools.common.publickey.bc.OpenSSHPrivateKeyFile" + JCEProvider.getBCProvider().getName());
                    Method is = clz.getMethod("isFormatted", byte[].class);
                    Boolean result = (Boolean)is.invoke(null, new Object[]{formattedkey});
                    if (result.booleanValue()) {
                        Constructor<?> c = clz.getDeclaredConstructor(byte[].class);
                        c.setAccessible(true);
                        return (SshPrivateKeyFile)c.newInstance(new Object[]{formattedkey});
                    }
                }
                catch (InvocationTargetException e) {
                    if (Boolean.getBoolean("maverick.verbose")) {
                        Log.warn((String)"OpenSSHPrivateKeyFile could not load using Bouncycastle PKIX", (Throwable)e.getTargetException(), (Object[])new Object[0]);
                    }
                }
                catch (Throwable t) {
                    if (!Boolean.getBoolean("maverick.verbose")) break block13;
                    Log.warn((String)"Bouncycastle PKIX not in classpath so falling back to older implementation of OpenSSHPrivateKeyFile.", (Throwable)t, (Object[])new Object[0]);
                }
            }
        }
        try {
            if (OpenSSHPrivateKeyFile.isFormatted(formattedkey)) {
                return new OpenSSHPrivateKeyFile(formattedkey);
            }
            if (Base64EncodedFileFormat.isFormatted(formattedkey, SshtoolsPrivateKeyFile.BEGIN, SshtoolsPrivateKeyFile.END)) {
                return new SshtoolsPrivateKeyFile(formattedkey);
            }
            if (Ssh1RsaPrivateKeyFile.isFormatted(formattedkey)) {
                return new Ssh1RsaPrivateKeyFile(formattedkey);
            }
            if (PuTTYPrivateKeyFile.isFormatted(formattedkey)) {
                return new PuTTYPrivateKeyFile(formattedkey);
            }
            if (SSHCOMPrivateKeyFile.isFormatted(formattedkey)) {
                return new SSHCOMPrivateKeyFile(formattedkey);
            }
            throw new IOException("A suitable key format could not be found!");
        }
        catch (OutOfMemoryError ex) {
            throw new IOException("An error occurred parsing a private key file! Is the file corrupt?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPrivateKeyFile parse(InputStream in) throws IOException {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((read = in.read()) > -1) {
                out.write(read);
            }
            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFileFactory.parse(out.toByteArray());
            return sshPrivateKeyFile;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPrivateKeyFile create(SshKeyPair pair) throws IOException {
        return SshPrivateKeyFileFactory.create(pair, null, 0);
    }

    public static SshPrivateKeyFile create(SshKeyPair pair, String passphrase) throws IOException {
        return SshPrivateKeyFileFactory.create(pair, passphrase, 0);
    }

    public static SshPrivateKeyFile create(SshKeyPair pair, String passphrase, int format) throws IOException {
        return SshPrivateKeyFileFactory.create(pair, passphrase, "", format);
    }

    public static SshPrivateKeyFile create(SshKeyPair pair, String passphrase, String comment) throws IOException {
        return SshPrivateKeyFileFactory.create(pair, passphrase, comment, 0);
    }

    public static SshPrivateKeyFile create(SshKeyPair pair, String passphrase, String comment, int format) throws IOException {
        switch (format) {
            case 4: {
                if (!JCEProvider.isBCEnabled()) {
                    throw new IOException("OpenSSL format requires maverick-bc dependency and BouncyCastle JCE and PKIX dependencies");
                }
                try {
                    return SshPrivateKeyFileFactory.tryBC(pair, passphrase);
                }
                catch (UnsupportedOperationException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            case 0: {
                if (JCEProvider.isBCEnabled()) {
                    try {
                        return SshPrivateKeyFileFactory.tryBC(pair, passphrase);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                return new OpenSSHPrivateKeyFile(pair, passphrase, comment);
            }
        }
        throw new IOException("Invalid key format!");
    }

    private static SshPrivateKeyFile tryBC(SshKeyPair pair, String passphrase) throws UnsupportedOperationException {
        try {
            Class<?> clz = Class.forName("com.sshtools.common.publickey.bc.OpenSSHPrivateKeyFile" + JCEProvider.getBCProvider().getName());
            Constructor<?> c = clz.getDeclaredConstructor(SshKeyPair.class, String.class);
            c.setAccessible(true);
            SshPrivateKeyFile f = (SshPrivateKeyFile)c.newInstance(pair, passphrase);
            f.toKeyPair(passphrase);
            return f;
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException(t);
        }
    }

    public static void createFile(SshKeyPair key, String passphrase, File toFile) throws IOException {
        SshPrivateKeyFileFactory.createFile(key, passphrase, 0, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(SshKeyPair key, String passphrase, int format, File toFile) throws IOException {
        SshPrivateKeyFile pub = SshPrivateKeyFileFactory.create(key, passphrase, format);
        try (FileOutputStream out = new FileOutputStream(toFile);){
            out.write(pub.getFormattedKey());
            out.flush();
        }
    }

    public static void convertFile(File keyFile, String passphrase, int toFormat, File toFile) throws IOException, InvalidPassphraseException {
        SshPrivateKeyFile pub = SshPrivateKeyFileFactory.parse(new FileInputStream(keyFile));
        SshPrivateKeyFileFactory.createFile(pub.toKeyPair(passphrase), passphrase, toFormat, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changePassphrase(File keyFile, String passphrase, String newPassphrase) throws IOException, InvalidPassphraseException {
        SshPrivateKeyFile pub = SshPrivateKeyFileFactory.parse(new FileInputStream(keyFile));
        pub.changePassphrase(passphrase, newPassphrase);
        try (FileOutputStream out = new FileOutputStream(keyFile);){
            out.write(pub.getFormattedKey());
            out.flush();
        }
    }
}

