/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.direct;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.AbstractDirectFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DirectFile
extends AbstractDirectFile<DirectFile> {
    public DirectFile(String path, AbstractFileFactory<DirectFile> fileFactory, File homeDir) throws IOException {
        super(path, fileFactory, homeDir);
    }

    @Override
    public SftpFileAttributes getAttributes() throws IOException {
        if (!this.f.exists()) {
            throw new FileNotFoundException();
        }
        SftpFileAttributes attrs = new SftpFileAttributes(this.getFileType(this.f), "UTF-8");
        attrs.setTimes(new UnsignedInteger64(this.f.lastModified() / 1000L), new UnsignedInteger64(this.f.lastModified() / 1000L));
        attrs.setPermissions(String.format("%s%s-------", this.isReadable() ? "r" : "-", this.isWritable() ? "w" : "-"));
        if (!this.isDirectory()) {
            attrs.setSize(new UnsignedInteger64(this.f.length()));
        }
        return attrs;
    }

    private int getFileType(File f) {
        if (f.isDirectory()) {
            return 2;
        }
        if (f.exists()) {
            return 1;
        }
        return 5;
    }

    @Override
    public List<AbstractFile> getChildren() throws IOException {
        File[] files = this.f.listFiles();
        ArrayList<AbstractFile> results = new ArrayList<AbstractFile>();
        for (File f : files) {
            results.add(new DirectFile(f.getAbsolutePath(), this.fileFactory, this.homeDir));
        }
        return results;
    }

    @Override
    public AbstractFile resolveFile(String child) throws IOException, PermissionDeniedException {
        File file = new File(child);
        if (!file.isAbsolute()) {
            file = new File(this.f, child);
        }
        return new DirectFile(file.getAbsolutePath(), this.fileFactory, this.homeDir);
    }
}

