/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files;

import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public interface AbstractFile {
    public String getName();

    public InputStream getInputStream() throws IOException, PermissionDeniedException;

    public boolean exists() throws IOException, PermissionDeniedException;

    public List<AbstractFile> getChildren() throws IOException, PermissionDeniedException;

    public String getAbsolutePath() throws IOException, PermissionDeniedException;

    public boolean isDirectory() throws IOException, PermissionDeniedException;

    public boolean isFile() throws IOException, PermissionDeniedException;

    public OutputStream getOutputStream() throws IOException, PermissionDeniedException;

    public boolean isHidden() throws IOException, PermissionDeniedException;

    public boolean createFolder() throws PermissionDeniedException, IOException;

    public boolean isReadable() throws IOException, PermissionDeniedException;

    public void copyFrom(AbstractFile var1) throws IOException, PermissionDeniedException;

    public void moveTo(AbstractFile var1) throws IOException, PermissionDeniedException;

    public boolean delete(boolean var1) throws IOException, PermissionDeniedException;

    public SftpFileAttributes getAttributes() throws FileNotFoundException, IOException, PermissionDeniedException;

    public void refresh();

    public long lastModified() throws IOException, PermissionDeniedException;

    public long length() throws IOException, PermissionDeniedException;

    public boolean isWritable() throws IOException, PermissionDeniedException;

    public boolean createNewFile() throws PermissionDeniedException, IOException;

    public void truncate() throws PermissionDeniedException, IOException;

    public void setAttributes(SftpFileAttributes var1) throws IOException;

    public String getCanonicalPath() throws IOException, PermissionDeniedException;

    public boolean supportsRandomAccess();

    public AbstractFileRandomAccess openFile(boolean var1) throws IOException, PermissionDeniedException;

    public OutputStream getOutputStream(boolean var1) throws IOException, PermissionDeniedException;

    public AbstractFile resolveFile(String var1) throws IOException, PermissionDeniedException;

    public AbstractFileFactory<? extends AbstractFile> getFileFactory();
}

