/*
 * Decompiled with CFR 0.152.
 */
package com.srotya.minuteman.rocksdb;

import com.srotya.minuteman.rocksdb.rpc.KeyValuePair;
import com.srotya.minuteman.rocksdb.rpc.PutRequest;
import com.srotya.minuteman.wal.LocalWALClient;
import com.srotya.minuteman.wal.WAL;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksDB;

public class RocksDBWALClient
extends LocalWALClient {
    private RocksDB rocksdb;
    private FlushOptions opts;

    public LocalWALClient configure(Map<String, String> conf, String nodeId, WAL localWAL, Object storageObject) throws IOException {
        super.configure(conf, nodeId, localWAL, storageObject);
        this.rocksdb = (RocksDB)storageObject;
        this.opts = new FlushOptions().setWaitForFlush(false);
        return this;
    }

    public void processData(List<byte[]> list) {
        try {
            for (byte[] entry : list) {
                PutRequest request = PutRequest.parseFrom(entry);
                if (request.getDelete()) {
                    for (KeyValuePair keyValuePair : request.getKvPairsList()) {
                        this.rocksdb.remove(keyValuePair.getKey().getBytes());
                    }
                    continue;
                }
                for (KeyValuePair keyValuePair : request.getKvPairsList()) {
                    this.rocksdb.put(keyValuePair.getKey().getBytes(), keyValuePair.getValue().toByteArray());
                }
            }
            this.rocksdb.flush(this.opts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

