/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.srcclr.sdk.BaseBuilder;
import com.srcclr.sdk.BaseModel;
import com.srcclr.sdk.LibraryLicense;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@JsonDeserialize(builder=Builder.class)
@Immutable
public class LibraryVersion
extends BaseModel {
    private final String version;
    private final Date releaseDate;
    private final String sha1;
    private final String sha2;
    private final String bytecodeHash;
    private final String platform;
    private final List<LibraryLicense> licenses;

    private LibraryVersion(Builder builder) {
        super(builder);
        this.version = builder.version;
        this.releaseDate = builder.releaseDate;
        this.sha1 = builder.sha1;
        this.sha2 = builder.sha2;
        this.bytecodeHash = builder.bytecodeHash;
        this.platform = builder.platform;
        this.licenses = builder.licenses;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getSha2() {
        return this.sha2;
    }

    public String getBytecodeHash() {
        return this.bytecodeHash;
    }

    public String getPlatform() {
        return this.platform;
    }

    public List<LibraryLicense> getLicenses() {
        return this.licenses;
    }

    public static class Builder
    extends BaseBuilder<Builder, LibraryVersion> {
        private String version;
        private Date releaseDate;
        private String sha1;
        private String sha2;
        private String bytecodeHash;
        private String platform;
        private List<LibraryLicense> licenses = new LinkedList<LibraryLicense>();

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withReleaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public Builder withSha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public Builder withSha2(String sha2) {
            this.sha2 = sha2;
            return this;
        }

        public Builder withBytecodeHash(String bytecodeHash) {
            this.bytecodeHash = bytecodeHash;
            return this;
        }

        public Builder withPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        public Builder withLicenses(List<LibraryLicense> licenses) {
            this.licenses = licenses;
            return this;
        }

        @Override
        public LibraryVersion build() {
            return new LibraryVersion(this);
        }
    }
}

