/*
 * Decompiled with CFR 0.152.
 */
package com.src.webrtc.android;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.src.webrtc.android.ConferenceParameters;
import com.src.webrtc.android.ConnectParameters;
import com.src.webrtc.android.ExecutorProvider;
import com.src.webrtc.android.Listener;
import com.src.webrtc.android.LocalPeer;
import com.src.webrtc.android.MediaFactory;
import com.src.webrtc.android.RemotePeer;
import com.src.webrtc.android.RemotePeerEvents;
import com.src.webrtc.android.Room;
import com.src.webrtc.android.Room$WhenMappings;
import com.src.webrtc.android.SDPType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.appspot.apprtc.PeerConnectionClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.IceCandidate;
import org.webrtc.RTCStatsReport;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u001b\u0018\u0000 02\u00020\u0001:\u00010B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0016\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0011J#\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000b2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110'\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000bJ\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000bJ\u001e\u0010+\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000bJ\u0006\u0010/\u001a\u00020\u001eR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/src/webrtc/android/Room;", "", "context", "Landroid/content/Context;", "connectParameters", "Lcom/src/webrtc/android/ConnectParameters;", "roomListener", "Lcom/src/webrtc/android/Listener$RoomListener;", "(Landroid/content/Context;Lcom/src/webrtc/android/ConnectParameters;Lcom/src/webrtc/android/Listener$RoomListener;)V", "_remotePeers", "", "", "Lcom/src/webrtc/android/RemotePeer;", "handler", "Landroid/os/Handler;", "iceCandidatesRecord", "", "Lorg/webrtc/IceCandidate;", "localPeer", "Lcom/src/webrtc/android/LocalPeer;", "getLocalPeer", "()Lcom/src/webrtc/android/LocalPeer;", "setLocalPeer", "(Lcom/src/webrtc/android/LocalPeer;)V", "peerConnectionParameters", "Lorg/appspot/apprtc/PeerConnectionClient$PeerConnectionParameters;", "remotePeerEvents", "com/src/webrtc/android/Room$remotePeerEvents$1", "Lcom/src/webrtc/android/Room$remotePeerEvents$1;", "connect", "", "disconnect", "disconnectPeer", "id", "onCandidateReceived", "peerId", "candidate", "onCandidatesRemoveReceived", "candidates", "", "(Ljava/lang/String;[Lorg/webrtc/IceCandidate;)V", "onPeerJoin", "onPeerLeave", "onSdpReceived", "type", "Lcom/src/webrtc/android/SDPType;", "sdp", "release", "Companion", "library_release"})
public final class Room {
    private final Handler handler;
    private PeerConnectionClient.PeerConnectionParameters peerConnectionParameters;
    private final Map<String, List<IceCandidate>> iceCandidatesRecord;
    @Nullable
    private LocalPeer localPeer;
    private final Map<String, RemotePeer> _remotePeers;
    private final remotePeerEvents.1 remotePeerEvents;
    private final Context context;
    private final ConnectParameters connectParameters;
    private final Listener.RoomListener roomListener;
    private static final String TAG = "[rtc]Room";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final LocalPeer getLocalPeer() {
        return this.localPeer;
    }

    public final void setLocalPeer(@Nullable LocalPeer localPeer) {
        this.localPeer = localPeer;
    }

    public final void connect() {
        Log.d((String)TAG, (String)"connect");
        PeerConnectionClient.PeerConnectionParameters peerConnectionParameters = new ConferenceParameters(this.context).getPeerConnectionParameters(this.connectParameters);
        Intrinsics.checkExpressionValueIsNotNull((Object)peerConnectionParameters, (String)"ConferenceParameters(con\u2026meters(connectParameters)");
        this.peerConnectionParameters = peerConnectionParameters;
        String string2 = this.connectParameters.getLocalPeerId();
        PeerConnectionClient.PeerConnectionParameters peerConnectionParameters2 = this.peerConnectionParameters;
        if (peerConnectionParameters2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"peerConnectionParameters");
        }
        this.localPeer = new LocalPeer(string2, this.context, this.connectParameters, peerConnectionParameters2, ExecutorProvider.INSTANCE.get());
        this.roomListener.onConnected(this);
    }

    public final void onPeerJoin(@NotNull String peerId) {
        Intrinsics.checkParameterIsNotNull((Object)peerId, (String)"peerId");
        Log.d((String)TAG, (String)("onPeerJoin " + peerId));
        if (this._remotePeers.containsKey(peerId)) {
            Log.e((String)TAG, (String)("Already has this remote peer " + peerId));
            return;
        }
        LocalPeer localPeer = this.localPeer;
        if (localPeer == null) {
            Intrinsics.throwNpe();
        }
        PeerConnectionClient.PeerConnectionParameters peerConnectionParameters = this.peerConnectionParameters;
        if (peerConnectionParameters == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"peerConnectionParameters");
        }
        RemotePeer remotePeer = new RemotePeer(peerId, this.context, true, localPeer, peerConnectionParameters, ExecutorProvider.INSTANCE.get(), this.remotePeerEvents);
        this._remotePeers.put(peerId, remotePeer);
        remotePeer.sdpHandshake();
    }

    public final void onPeerLeave(@NotNull String peerId) {
        Intrinsics.checkParameterIsNotNull((Object)peerId, (String)"peerId");
        Log.d((String)TAG, (String)("onPeerLeave " + peerId));
        this.disconnectPeer(peerId);
    }

    public final void disconnect() {
        Log.d((String)TAG, (String)"disconnect");
        Map<String, RemotePeer> map = this._remotePeers;
        boolean bl = false;
        if (!map.isEmpty()) {
            Map<String, RemotePeer> $this$forEach$iv = this._remotePeers;
            boolean $i$f$forEach = false;
            Map<String, RemotePeer> map2 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator<Map.Entry<String, RemotePeer>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, RemotePeer> element$iv;
                Map.Entry<String, RemotePeer> $dstr$_u24__u24$peer = element$iv = iterator.next();
                boolean bl3 = false;
                Map.Entry<String, RemotePeer> entry = $dstr$_u24__u24$peer;
                boolean bl4 = false;
                RemotePeer peer = entry.getValue();
                peer.release();
            }
            this._remotePeers.clear();
        }
        LocalPeer localPeer = this.localPeer;
        if (localPeer == null) {
            Intrinsics.throwNpe();
        }
        localPeer.release();
        this.localPeer = null;
        this.roomListener.onDisconnected(this);
    }

    public final void onSdpReceived(@NotNull String peerId, @NotNull SDPType type, @NotNull String sdp) {
        Intrinsics.checkParameterIsNotNull((Object)peerId, (String)"peerId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)sdp, (String)"sdp");
        Log.d((String)TAG, (String)("onSdpReceived " + peerId + ' ' + (Object)((Object)type) + ' ' + sdp));
        switch (Room$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                if (this._remotePeers.containsKey(peerId)) {
                    Log.e((String)TAG, (String)"Already has this remote peer.");
                    return;
                }
                LocalPeer localPeer = this.localPeer;
                if (localPeer == null) {
                    Intrinsics.throwNpe();
                }
                PeerConnectionClient.PeerConnectionParameters peerConnectionParameters = this.peerConnectionParameters;
                if (peerConnectionParameters == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"peerConnectionParameters");
                }
                RemotePeer remotePeer = new RemotePeer(peerId, this.context, false, localPeer, peerConnectionParameters, ExecutorProvider.INSTANCE.get(), this.remotePeerEvents);
                this._remotePeers.put(peerId, remotePeer);
                SessionDescription sessionDescription = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)SDPType.OFFER.getValue()), sdp);
                remotePeer.sdpHandshake();
                remotePeer.onRemoteDescription(sessionDescription);
                Map<String, List<IceCandidate>> map = this.iceCandidatesRecord;
                boolean bl = false;
                if (!(!map.isEmpty()) || !this.iceCandidatesRecord.containsKey(peerId)) break;
                List<IceCandidate> list = this.iceCandidatesRecord.get(peerId);
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IceCandidate it = (IceCandidate)element$iv;
                    boolean bl2 = false;
                    remotePeer.addRemoteIceCandidate(it);
                }
                this.iceCandidatesRecord.remove(peerId);
                break;
            }
            case 2: {
                RemotePeer remotePeer = this._remotePeers.get(peerId);
                if (remotePeer == null) {
                    Log.e((String)TAG, (String)"Can't find the remote peer.");
                    return;
                }
                SessionDescription sessionDescription = new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)SDPType.ANSWER.getValue()), sdp);
                remotePeer.onRemoteDescription(sessionDescription);
                break;
            }
        }
    }

    public final void onCandidateReceived(@NotNull String peerId, @NotNull IceCandidate candidate) {
        Intrinsics.checkParameterIsNotNull((Object)peerId, (String)"peerId");
        Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
        Log.d((String)TAG, (String)("onCandidateReceived " + peerId));
        RemotePeer remotePeer = this._remotePeers.get(peerId);
        if (remotePeer == null) {
            if (this.iceCandidatesRecord.containsKey(peerId)) {
                List<IceCandidate> list = this.iceCandidatesRecord.get(peerId);
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                list.add(candidate);
            } else {
                boolean bl = false;
                List candidates = new ArrayList();
                candidates.add(candidate);
                this.iceCandidatesRecord.put(peerId, candidates);
            }
        } else {
            remotePeer.addRemoteIceCandidate(candidate);
        }
    }

    public final void onCandidatesRemoveReceived(@NotNull String peerId, @NotNull IceCandidate[] candidates) {
        Intrinsics.checkParameterIsNotNull((Object)peerId, (String)"peerId");
        Intrinsics.checkParameterIsNotNull((Object)candidates, (String)"candidates");
        Log.d((String)TAG, (String)("onCandidatesRemoveReceived " + peerId));
        RemotePeer remotePeer = this._remotePeers.get(peerId);
        if (remotePeer == null) {
            Log.e((String)TAG, (String)("Can't find the remote peer " + peerId));
            return;
        }
        remotePeer.removeRemoteIceCandidates(candidates);
    }

    public final void release() {
        Log.d((String)TAG, (String)"release");
        MediaFactory.Companion.get(this.context).release();
        ExecutorProvider.INSTANCE.release();
    }

    private final void disconnectPeer(String id) {
        this.handler.post(new Runnable(this, id){
            final /* synthetic */ Room this$0;
            final /* synthetic */ String $id;

            public final void run() {
                Log.d((String)"[rtc]Room", (String)("disconnectPeer " + this.$id));
                RemotePeer remotePeer = (RemotePeer)Room.access$get_remotePeers$p(this.this$0).remove(this.$id);
                if (remotePeer == null) {
                    Log.e((String)"[rtc]Room", (String)("Can't find the remote peer " + this.$id));
                    return;
                }
                Room.access$getRoomListener$p(this.this$0).onPeerDisconnected(this.this$0, remotePeer);
                remotePeer.release();
            }
            {
                this.this$0 = room;
                this.$id = string2;
            }
        });
    }

    private Room(Context context, ConnectParameters connectParameters, Listener.RoomListener roomListener) {
        Map map;
        this.context = context;
        this.connectParameters = connectParameters;
        this.roomListener = roomListener;
        this.handler = new Handler(Looper.getMainLooper());
        Room room = this;
        boolean bl = false;
        room.iceCandidatesRecord = map = (Map)new LinkedHashMap();
        room = this;
        bl = false;
        room._remotePeers = map = (Map)new LinkedHashMap();
        this.remotePeerEvents = new RemotePeerEvents(this){
            final /* synthetic */ Room this$0;

            public void onLocalDescription(@NotNull String to, @NotNull SDPType type, @NotNull String sdp) {
                Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                Intrinsics.checkParameterIsNotNull((Object)sdp, (String)"sdp");
                Room.access$getHandler$p(this.this$0).post(new Runnable(this, to, type, sdp){
                    final /* synthetic */ remotePeerEvents.1 this$0;
                    final /* synthetic */ String $to;
                    final /* synthetic */ SDPType $type;
                    final /* synthetic */ String $sdp;

                    public final void run() {
                        Room.access$getRoomListener$p(this.this$0.this$0).onLocalDescription(this.$to, this.$type, this.$sdp);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$to = string2;
                        this.$type = sDPType;
                        this.$sdp = string3;
                    }
                });
            }

            public void onIceCandidate(@NotNull String to, @NotNull IceCandidate iceCandidate) {
                Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
                Intrinsics.checkParameterIsNotNull((Object)iceCandidate, (String)"iceCandidate");
                Room.access$getHandler$p(this.this$0).post(new Runnable(this, to, iceCandidate){
                    final /* synthetic */ remotePeerEvents.1 this$0;
                    final /* synthetic */ String $to;
                    final /* synthetic */ IceCandidate $iceCandidate;

                    public final void run() {
                        Room.access$getRoomListener$p(this.this$0.this$0).onIceCandidate(this.$to, this.$iceCandidate);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$to = string2;
                        this.$iceCandidate = iceCandidate;
                    }
                });
            }

            public void onIceCandidatesRemoved(@NotNull String to, @NotNull IceCandidate[] iceCandidates) {
                Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
                Intrinsics.checkParameterIsNotNull((Object)iceCandidates, (String)"iceCandidates");
                Room.access$getHandler$p(this.this$0).post(new Runnable(this, to, iceCandidates){
                    final /* synthetic */ remotePeerEvents.1 this$0;
                    final /* synthetic */ String $to;
                    final /* synthetic */ IceCandidate[] $iceCandidates;

                    public final void run() {
                        Room.access$getRoomListener$p(this.this$0.this$0).onIceCandidatesRemove(this.$to, this.$iceCandidates);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$to = string2;
                        this.$iceCandidates = iceCandidateArray;
                    }
                });
            }

            public void onIceConnected(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Log.d((String)"[rtc]Room", (String)("onIceConnected " + id));
            }

            public void onIceDisconnected(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Log.d((String)"[rtc]Room", (String)("onIceDisconnected " + id));
            }

            public void onConnected(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Room.access$getHandler$p(this.this$0).post(new Runnable(this, id){
                    final /* synthetic */ remotePeerEvents.1 this$0;
                    final /* synthetic */ String $id;

                    public final void run() {
                        Log.d((String)"[rtc]Room", (String)("onConnected " + this.$id));
                        RemotePeer remotePeer = (RemotePeer)Room.access$get_remotePeers$p(this.this$0.this$0).get(this.$id);
                        if (remotePeer == null) {
                            Log.e((String)"[rtc]Room", (String)("Remote peer " + this.$id + " not found"));
                            return;
                        }
                        Room.access$getRoomListener$p(this.this$0.this$0).onPeerConnected(this.this$0.this$0, remotePeer);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$id = string2;
                    }
                });
            }

            public void onDisconnected(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Log.d((String)"[rtc]Room", (String)("onDisconnected " + id));
            }

            public void onPeerConnectionClose(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Log.d((String)"[rtc]Room", (String)("onPeerConnectionClose " + id));
            }

            public void onPeerConnectionStatsReady(@NotNull String id, @NotNull StatsReport[] reports) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull((Object)reports, (String)"reports");
                String string2 = "Not yet implemented";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }

            public void onPeerConnectionStatsReady(@NotNull String id, @NotNull RTCStatsReport report) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull((Object)report, (String)"report");
                String string2 = "Not yet implemented";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }

            public void onPeerConnectionError(@NotNull String id, @NotNull String description) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
                Log.d((String)"[rtc]Room", (String)("onPeerConnectionError " + id + ' ' + description));
                Room.access$disconnectPeer(this.this$0, id);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ Map access$get_remotePeers$p(Room $this) {
        return $this._remotePeers;
    }

    public static final /* synthetic */ Listener.RoomListener access$getRoomListener$p(Room $this) {
        return $this.roomListener;
    }

    public static final /* synthetic */ Handler access$getHandler$p(Room $this) {
        return $this.handler;
    }

    public static final /* synthetic */ void access$disconnectPeer(Room $this, String id) {
        $this.disconnectPeer(id);
    }

    public /* synthetic */ Room(Context context, ConnectParameters connectParameters, Listener.RoomListener roomListener, DefaultConstructorMarker $constructor_marker) {
        this(context, connectParameters, roomListener);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/src/webrtc/android/Room$Companion;", "", "()V", "TAG", "", "connect", "Lcom/src/webrtc/android/Room;", "context", "Landroid/content/Context;", "connectParameters", "Lcom/src/webrtc/android/ConnectParameters;", "roomListener", "Lcom/src/webrtc/android/Listener$RoomListener;", "library_release"})
    public static final class Companion {
        @NotNull
        public final Room connect(@NotNull Context context, @NotNull ConnectParameters connectParameters, @NotNull Listener.RoomListener roomListener) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)connectParameters, (String)"connectParameters");
            Intrinsics.checkParameterIsNotNull((Object)roomListener, (String)"roomListener");
            Room room = new Room(context, connectParameters, roomListener, null);
            room.connect();
            return room;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

