/*
 * Decompiled with CFR 0.152.
 */
package com.src.webrtc.android;

import android.content.Context;
import android.util.Log;
import com.src.webrtc.android.Listener;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.VideoCapturer;

public class CameraCaptureManager {
    private static final String TAG = "[rtc]CameraCaptureManager";
    private Context context;
    private VideoCapturer videoCapturer;

    public VideoCapturer getVideoCapturer() {
        Log.d((String)TAG, (String)"createVideoCapture");
        if (this.useCamera2()) {
            Log.d((String)TAG, (String)"Creating capturer using camera2 API.");
            this.videoCapturer = this.createCameraCapturer((CameraEnumerator)new Camera2Enumerator(this.context));
        } else {
            Log.d((String)TAG, (String)"Creating capturer using camera1 API.");
            this.videoCapturer = this.createCameraCapturer((CameraEnumerator)new Camera1Enumerator(false));
        }
        if (this.videoCapturer == null) {
            Log.e((String)TAG, (String)"Failed to open camera");
        }
        return this.videoCapturer;
    }

    public void switchCamera(final Listener.CameraSwitchListener listener) {
        if (this.videoCapturer == null) {
            return;
        }
        if (this.videoCapturer instanceof CameraVideoCapturer) {
            CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
            cameraVideoCapturer.switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                public void onCameraSwitchDone(boolean b) {
                    listener.onCameraSwitchDone(b);
                }

                public void onCameraSwitchError(String s) {
                    listener.onCameraSwitchError(s);
                }
            });
        } else {
            Log.e((String)TAG, (String)"Will not switch camera, video capturer is not a camera");
        }
    }

    public CameraCaptureManager(Context context) {
        this.context = context;
    }

    private VideoCapturer createCameraCapturer(CameraEnumerator enumerator) {
        CameraVideoCapturer videoCapturer;
        String[] deviceNames = enumerator.getDeviceNames();
        Log.d((String)TAG, (String)"Looking for front facing cameras.");
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) continue;
            Log.d((String)TAG, (String)"Creating front facing camera capturer.");
            videoCapturer = enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        Log.d((String)TAG, (String)"Looking for other cameras.");
        for (String deviceName : deviceNames) {
            if (enumerator.isFrontFacing(deviceName)) continue;
            Log.d((String)TAG, (String)"Creating other camera capturer.");
            videoCapturer = enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        return null;
    }

    private boolean useCamera2() {
        return Camera2Enumerator.isSupported((Context)this.context);
    }
}

