/*
 * Decompiled with CFR 0.152.
 */
package org.appspot.apprtc;

import android.os.Environment;
import android.util.Log;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.webrtc.audio.JavaAudioDeviceModule;

public class RecordedAudioToFileController
implements JavaAudioDeviceModule.SamplesReadyCallback {
    private static final String TAG = "RecordedAudioToFile";
    private static final long MAX_FILE_SIZE_IN_BYTES = 58348800L;
    private final Object lock = new Object();
    private final ExecutorService executor;
    @Nullable
    private OutputStream rawAudioFileOutputStream;
    private boolean isRunning;
    private long fileSizeInBytes;

    public RecordedAudioToFileController(ExecutorService executor) {
        Log.d((String)TAG, (String)"ctor");
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Log.d((String)TAG, (String)"start");
        if (!this.isExternalStorageWritable()) {
            Log.e((String)TAG, (String)"Writing to external media is not possible");
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Log.d((String)TAG, (String)"stop");
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = false;
            if (this.rawAudioFileOutputStream != null) {
                try {
                    this.rawAudioFileOutputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("Failed to close file with saved input audio: " + e));
                }
                this.rawAudioFileOutputStream = null;
            }
            this.fileSizeInBytes = 0L;
        }
    }

    private boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    private void openRawAudioOutputFile(int sampleRate, int channelCount) {
        String fileName = Environment.getExternalStorageDirectory().getPath() + File.separator + "recorded_audio_16bits_" + String.valueOf(sampleRate) + "Hz" + (channelCount == 1 ? "_mono" : "_stereo") + ".pcm";
        File outputFile = new File(fileName);
        try {
            this.rawAudioFileOutputStream = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("Failed to open audio output file: " + e.getMessage()));
        }
        Log.d((String)TAG, (String)("Opened file for recording: " + fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebRtcAudioRecordSamplesReady(JavaAudioDeviceModule.AudioSamples samples) {
        if (samples.getAudioFormat() != 2) {
            Log.e((String)TAG, (String)"Invalid audio format");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning) {
                return;
            }
            if (this.rawAudioFileOutputStream == null) {
                this.openRawAudioOutputFile(samples.getSampleRate(), samples.getChannelCount());
                this.fileSizeInBytes = 0L;
            }
        }
        this.executor.execute(() -> {
            if (this.rawAudioFileOutputStream != null) {
                try {
                    if (this.fileSizeInBytes < 58348800L) {
                        this.rawAudioFileOutputStream.write(samples.getData());
                        this.fileSizeInBytes += (long)samples.getData().length;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("Failed to write audio to file: " + e.getMessage()));
                }
            }
        });
    }
}

