/*
 * Decompiled with CFR 0.152.
 */
package com.src.webrtc.android;

import android.util.Log;
import com.src.webrtc.android.DataTrack;
import com.src.webrtc.android.DataTrackOptions;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.webrtc.DataChannel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000bJ\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/src/webrtc/android/LocalDataTrack;", "Lcom/src/webrtc/android/DataTrack;", "id", "", "options", "Lcom/src/webrtc/android/DataTrackOptions;", "(Ljava/lang/String;Lcom/src/webrtc/android/DataTrackOptions;)V", "getId", "()Ljava/lang/String;", "internalDataChannels", "", "Lorg/webrtc/DataChannel;", "getOptions", "()Lcom/src/webrtc/android/DataTrackOptions;", "initInternalDataChannel", "", "internalDataChannel", "release", "send", "", "messageBuffer", "Ljava/nio/ByteBuffer;", "message", "Companion", "library_release"})
public final class LocalDataTrack
extends DataTrack {
    private final Map<String, DataChannel> internalDataChannels;
    @NotNull
    private final String id;
    @NotNull
    private final DataTrackOptions options;
    private static final String TAG = "[rtc]LocalDataTrack";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final boolean send(@NotNull ByteBuffer messageBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)messageBuffer, (String)"messageBuffer");
        if (this.internalDataChannels.isEmpty()) {
            return false;
        }
        Map<String, DataChannel> $this$forEach$iv = this.internalDataChannels;
        boolean $i$f$forEach = false;
        Map<String, DataChannel> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, DataChannel>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void id;
            Map.Entry<String, DataChannel> element$iv;
            Map.Entry<String, DataChannel> $dstr$id$channel = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, DataChannel> entry = $dstr$id$channel;
            boolean bl3 = false;
            String string2 = entry.getKey();
            entry = $dstr$id$channel;
            bl3 = false;
            DataChannel channel = entry.getValue();
            boolean result = channel.send(new DataChannel.Buffer(messageBuffer, true));
            Log.d((String)TAG, (String)("send ByteBuffer to " + (String)id + ", result: " + result));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean send(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.internalDataChannels.isEmpty()) {
            return false;
        }
        Map<String, DataChannel> $this$forEach$iv = this.internalDataChannels;
        boolean $i$f$forEach = false;
        Map<String, DataChannel> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, DataChannel>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void id;
            Map.Entry<String, DataChannel> element$iv;
            Map.Entry<String, DataChannel> $dstr$id$channel = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, DataChannel> entry = $dstr$id$channel;
            boolean bl3 = false;
            String string2 = entry.getKey();
            entry = $dstr$id$channel;
            bl3 = false;
            DataChannel channel = entry.getValue();
            ByteBuffer buff = Charset.forName("UTF-8").encode(message);
            boolean result = channel.send(new DataChannel.Buffer(buff, false));
            Log.d((String)TAG, (String)("send message to " + (String)id + ", label:" + channel.label() + " result: " + result));
        }
        return true;
    }

    @Override
    public void release() {
        Map<String, DataChannel> $this$forEach$iv = this.internalDataChannels;
        boolean $i$f$forEach = false;
        Map<String, DataChannel> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, DataChannel>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataChannel> element$iv;
            Map.Entry<String, DataChannel> $dstr$_u24__u24$channel = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, DataChannel> entry = $dstr$_u24__u24$channel;
            boolean bl3 = false;
            DataChannel channel = entry.getValue();
            channel.dispose();
        }
        this.internalDataChannels.clear();
    }

    public final void initInternalDataChannel(@NotNull String id, @NotNull DataChannel internalDataChannel) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)internalDataChannel, (String)"internalDataChannel");
        this.internalDataChannels.put(id, internalDataChannel);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final DataTrackOptions getOptions() {
        return this.options;
    }

    public LocalDataTrack(@NotNull String id, @NotNull DataTrackOptions options) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.id = id;
        this.options = options;
        LocalDataTrack localDataTrack = this;
        boolean bl = false;
        localDataTrack.internalDataChannels = map = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/src/webrtc/android/LocalDataTrack$Companion;", "", "()V", "TAG", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

