/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.workflow1.ui.backstack;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.savedstate.SavedStateRegistryOwner;
import com.squareup.workflow1.ui.Named;
import com.squareup.workflow1.ui.WorkflowUiExperimentalApi;
import com.squareup.workflow1.ui.androidx.WorkflowSavedStateRegistryAggregator;
import com.squareup.workflow1.ui.backstack.ViewStateCache;
import com.squareup.workflow1.ui.backstack.ViewStateCacheKt;
import com.squareup.workflow1.ui.backstack.ViewStateFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001d\b\u0001\u0012\u0014\b\u0001\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0012\u001a\u00020\r2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014J\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J*\u0010\u001b\u001a\u00020\r2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/squareup/workflow1/ui/backstack/ViewStateCache;", "", "()V", "viewStates", "", "", "Lcom/squareup/workflow1/ui/backstack/ViewStateFrame;", "(Ljava/util/Map;)V", "stateRegistryAggregator", "Lcom/squareup/workflow1/ui/androidx/WorkflowSavedStateRegistryAggregator;", "getViewStates$wf1_container_android", "()Ljava/util/Map;", "attachToParentRegistryOwner", "", "key", "parentOwner", "Landroidx/savedstate/SavedStateRegistryOwner;", "detachFromParentRegistry", "prune", "retaining", "", "Lcom/squareup/workflow1/ui/Named;", "pruneAllKeysExcept", "restore", "from", "Lcom/squareup/workflow1/ui/backstack/ViewStateCache$Saved;", "save", "update", "retainedRenderings", "oldViewMaybe", "Landroid/view/View;", "newView", "Saved", "wf1-container-android"})
@WorkflowUiExperimentalApi
public final class ViewStateCache {
    @NotNull
    private final Map<String, ViewStateFrame> viewStates;
    @NotNull
    private final WorkflowSavedStateRegistryAggregator stateRegistryAggregator;

    @VisibleForTesting(otherwise=2)
    public ViewStateCache(@VisibleForTesting(otherwise=2) @NotNull Map<String, ViewStateFrame> viewStates) {
        Intrinsics.checkNotNullParameter(viewStates, (String)"viewStates");
        this.viewStates = viewStates;
        this.stateRegistryAggregator = new WorkflowSavedStateRegistryAggregator();
    }

    @NotNull
    public final Map<String, ViewStateFrame> getViewStates$wf1_container_android() {
        return this.viewStates;
    }

    public ViewStateCache() {
        this(new LinkedHashMap());
    }

    /*
     * WARNING - void declaration
     */
    public final void prune(@NotNull Collection<? extends Named<?>> retaining) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(retaining, (String)"retaining");
        Iterable iterable = retaining;
        ViewStateCache viewStateCache = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Named named2 = (Named)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCompatibilityKey());
        }
        viewStateCache.pruneAllKeysExcept((List)destination$iv$iv);
    }

    private final void pruneAllKeysExcept(Collection<String> retaining) {
        Set deadKeys = SetsKt.minus(this.viewStates.keySet(), (Iterable)retaining);
        CollectionsKt.removeAll((Collection)this.viewStates.keySet(), (Iterable)deadKeys);
        this.stateRegistryAggregator.pruneAllChildRegistryOwnersExcept(retaining);
    }

    public final void update(@NotNull Collection<? extends Named<?>> retainedRenderings, @Nullable View oldViewMaybe, @NotNull View newView) {
        Intrinsics.checkNotNullParameter(retainedRenderings, (String)"retainedRenderings");
        Intrinsics.checkNotNullParameter((Object)newView, (String)"newView");
        String newKey = ViewStateCacheKt.access$getNamedKey(newView);
        Object object = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)retainedRenderings), (Function1)update.hiddenKeys.1.INSTANCE));
        Set $this$update_u24lambda_u2d2 = object;
        boolean bl = false;
        if (!(retainedRenderings.size() == $this$update_u24lambda_u2d2.size())) {
            boolean bl2 = false;
            String string = "Duplicate entries not allowed in " + retainedRenderings + '.';
            throw new IllegalArgumentException(string.toString());
        }
        Set hiddenKeys2 = object;
        this.stateRegistryAggregator.installChildRegistryOwnerOn(newView, newKey);
        object = this.viewStates.remove(newKey);
        if (object != null) {
            Object it = object;
            boolean bl3 = false;
            newView.restoreHierarchyState(((ViewStateFrame)it).getViewState());
        }
        if (oldViewMaybe != null) {
            String string;
            String it = string = ViewStateCacheKt.access$getNamedKey(oldViewMaybe);
            boolean bl4 = false;
            Object object2 = object = hiddenKeys2.contains(it) ? string : null;
            if (object != null) {
                Object savedKey = object;
                boolean bl5 = false;
                Object object3 = new SparseArray();
                SparseArray $this$update_u24lambda_u2d6_u24lambda_u2d5 = object3;
                boolean bl6 = false;
                oldViewMaybe.saveHierarchyState($this$update_u24lambda_u2d6_u24lambda_u2d5);
                SparseArray saved = object3;
                object3 = this.getViewStates$wf1_container_android();
                Pair pair = TuplesKt.to((Object)savedKey, (Object)new ViewStateFrame((String)savedKey, (SparseArray<Parcelable>)saved));
                object3.put(pair.getFirst(), pair.getSecond());
                this.stateRegistryAggregator.saveAndPruneChildRegistryOwner((String)savedKey);
            }
        }
        this.pruneAllKeysExcept(SetsKt.plus((Set)hiddenKeys2, (Object)newKey));
    }

    public final void attachToParentRegistryOwner(@NotNull String key, @NotNull SavedStateRegistryOwner parentOwner) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)parentOwner, (String)"parentOwner");
        this.stateRegistryAggregator.attachToParentRegistry(key, parentOwner);
    }

    public final void detachFromParentRegistry() {
        this.stateRegistryAggregator.detachFromParentRegistry();
    }

    public final void restore(@NotNull Saved from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this.viewStates.clear();
        this.viewStates.putAll(from.getViewStates$wf1_container_android());
    }

    @NotNull
    public final Saved save() {
        return new Saved(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000fH\u0016R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/squareup/workflow1/ui/backstack/ViewStateCache$Saved;", "Landroid/os/Parcelable;", "viewStateCache", "Lcom/squareup/workflow1/ui/backstack/ViewStateCache;", "(Lcom/squareup/workflow1/ui/backstack/ViewStateCache;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "viewStates", "", "", "Lcom/squareup/workflow1/ui/backstack/ViewStateFrame;", "getViewStates$wf1_container_android", "()Ljava/util/Map;", "describeContents", "", "writeToParcel", "", "out", "flags", "CREATOR", "wf1-container-android"})
    public static final class Saved
    implements Parcelable {
        @NotNull
        public static final CREATOR CREATOR = new CREATOR(null);
        @NotNull
        private final Map<String, ViewStateFrame> viewStates;

        public Saved(@NotNull ViewStateCache viewStateCache) {
            Intrinsics.checkNotNullParameter((Object)viewStateCache, (String)"viewStateCache");
            this.viewStates = MapsKt.toMap(viewStateCache.getViewStates$wf1_container_android());
        }

        /*
         * WARNING - void declaration
         */
        public Saved(@NotNull Parcel source) {
            void $this$_init__u24lambda_u2d0;
            Map map;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Map map2 = map = (Map)new LinkedHashMap();
            Saved saved = this;
            boolean bl = false;
            source.readMap(TypeIntrinsics.asMutableMap((Object)$this$_init__u24lambda_u2d0), ViewStateCache.class.getClassLoader());
            saved.viewStates = MapsKt.toMap((Map)map);
        }

        @NotNull
        public final Map<String, ViewStateFrame> getViewStates$wf1_container_android() {
            return this.viewStates;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeMap(this.viewStates);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/squareup/workflow1/ui/backstack/ViewStateCache$Saved$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/squareup/workflow1/ui/backstack/ViewStateCache$Saved;", "()V", "createFromParcel", "source", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/squareup/workflow1/ui/backstack/ViewStateCache$Saved;", "wf1-container-android"})
        public static final class CREATOR
        implements Parcelable.Creator<Saved> {
            private CREATOR() {
            }

            @NotNull
            public Saved createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new Saved(source);
            }

            @NotNull
            public Saved[] newArray(int size) {
                return new Saved[size];
            }

            public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

