/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.java.ProfileLoader;
import com.squareup.wire.kotlin.KotlinGenerator;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\n\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u001c\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J$\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\fJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\u001dR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/squareup/wire/schema/RepoBuilder;", "", "()V", "fs", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "root", "Ljava/nio/file/Path;", "schemaLoader", "Lcom/squareup/wire/schema/SchemaLoader;", "add", "path", "", "name", "protoFile", "generateCode", "typeName", "profile", "generateGrpcKotlin", "serviceName", "rpcName", "blockingServices", "", "generateKotlin", "Lcom/squareup/wire/java/Profile;", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "messageTypeName", "schema", "Lcom/squareup/wire/schema/Schema;", "wire-test-utils"})
public final class RepoBuilder {
    private final FileSystem fs = Jimfs.newFileSystem((Configuration)Configuration.unix());
    private final Path root = this.fs.getPath("/source", new String[0]);
    private final SchemaLoader schemaLoader = new SchemaLoader().addSource(this.root);

    @NotNull
    public final RepoBuilder add(@NotNull String name, @NotNull String protoFile) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)protoFile, (String)"protoFile");
        if (StringsKt.endsWith$default((String)name, (String)".proto", (boolean)false, (int)2, null)) {
            this.schemaLoader.addProto(name);
        } else if (!StringsKt.endsWith$default((String)name, (String)".wire", (boolean)false, (int)2, null)) {
            throw (Throwable)new IllegalArgumentException("unexpected file extension: " + name);
        }
        Path relativePath = this.fs.getPath(name, new String[0]);
        try {
            Path resolvedPath;
            Path path = resolvedPath = this.root.resolve(relativePath);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"resolvedPath");
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            String string = protoFile;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            Path path2 = resolvedPath;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            Files.write(path2, byArray2, new OpenOption[0]);
        }
        catch (IOException e) {
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RepoBuilder add(@NotNull String path) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = new File("../wire-tests/src/test/proto/" + path);
        Closeable closeable = (Closeable)Okio.source((File)file);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Source source = (Source)closeable;
            boolean bl2 = false;
            String protoFile = Okio.buffer((Source)source).readUtf8();
            RepoBuilder repoBuilder = this.add(path, protoFile);
            return repoBuilder;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Schema schema() {
        try {
            Schema schema = this.schemaLoader.load();
            Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"schemaLoader.load()");
            return schema;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final Profile profile(@NotNull String name) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Profile profile = new ProfileLoader(this.fs, name).schema(this.schema()).load();
        Intrinsics.checkExpressionValueIsNotNull((Object)profile, (String)"ProfileLoader(fs, name)\n\u2026schema())\n        .load()");
        return profile;
    }

    @NotNull
    public final ProtoAdapter<Object> protoAdapter(@NotNull String messageTypeName) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)messageTypeName, (String)"messageTypeName");
        ProtoAdapter protoAdapter = this.schema().protoAdapter(messageTypeName, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)protoAdapter, (String)"schema().protoAdapter(messageTypeName, true)");
        return protoAdapter;
    }

    @JvmOverloads
    @NotNull
    public final String generateCode(@NotNull String typeName, @Nullable String profile) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        Schema schema = this.schema();
        JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema);
        if (profile != null) {
            javaGenerator = javaGenerator.withProfile(this.profile(profile));
        }
        Type type = schema.getType(typeName);
        TypeSpec typeSpec = javaGenerator.generateType(type);
        ClassName typeName1 = javaGenerator.generatedTypeName(type);
        String string = JavaFile.builder((String)typeName1.packageName(), (TypeSpec)typeSpec).build().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaFile.builder(typeNam\u2026eSpec).build().toString()");
        return string;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String generateCode$default(RepoBuilder repoBuilder, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return repoBuilder.generateCode(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final String generateCode(@NotNull String typeName) throws IOException {
        return RepoBuilder.generateCode$default(this, typeName, null, 2, null);
    }

    @NotNull
    public final String generateKotlin(@NotNull String typeName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        Schema schema = this.schema();
        KotlinGenerator kotlinGenerator = KotlinGenerator.Companion.get(schema, false, false, false);
        Type type = schema.getType(typeName);
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"schema.getType(typeName)");
        com.squareup.kotlinpoet.TypeSpec typeSpec = kotlinGenerator.generateType(type);
        FileSpec fileSpec = FileSpec.Companion.builder("", "_").addType(typeSpec).addImport("com.squareup.wire.kotlin", new String[]{"decodeMessage"}).build();
        return fileSpec.toString();
    }

    @NotNull
    public final String generateGrpcKotlin(@NotNull String serviceName, @Nullable String rpcName, boolean blockingServices) {
        Rpc rpc;
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        Schema schema = this.schema();
        KotlinGenerator grpcGenerator = KotlinGenerator.Companion.get(schema, false, false, blockingServices);
        Service service = schema.getService(serviceName);
        String string = rpcName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            rpc = service.rpc(rpcName);
            if (rpc == null) {
                Intrinsics.throwNpe();
            }
        } else {
            rpc = null;
        }
        Rpc rpc2 = rpc;
        Service service2 = service;
        Intrinsics.checkExpressionValueIsNotNull((Object)service2, (String)"service");
        com.squareup.kotlinpoet.TypeSpec typeSpec = grpcGenerator.generateService(service2, rpc2);
        String packageName = service.type().enclosingTypeOrPackage();
        String string3 = packageName;
        if (string3 == null) {
            string3 = "";
        }
        FileSpec fileSpec = FileSpec.Companion.builder(string3, "_").addType(typeSpec).build();
        return fileSpec.toString();
    }

    @NotNull
    public static /* synthetic */ String generateGrpcKotlin$default(RepoBuilder repoBuilder, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return repoBuilder.generateGrpcKotlin(string, string2, bl);
    }
}

