/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.java.ProfileLoader;
import com.squareup.wire.kotlin.KotlinGenerator;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import okio.Okio;
import okio.Source;

public final class RepoBuilder {
    final FileSystem fs = Jimfs.newFileSystem((Configuration)Configuration.unix());
    final Path root = this.fs.getPath("/source", new String[0]);
    final SchemaLoader schemaLoader = new SchemaLoader().addSource(this.root);

    public RepoBuilder add(String name, String protoFile) {
        if (name.endsWith(".proto")) {
            this.schemaLoader.addProto(name);
        } else if (!name.endsWith(".wire")) {
            throw new IllegalArgumentException("unexpected file extension: " + name);
        }
        Path relativePath = this.fs.getPath(name, new String[0]);
        try {
            Path resolvedPath = this.root.resolve(relativePath);
            Path parent = resolvedPath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(resolvedPath, protoFile.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public RepoBuilder add(String path) throws IOException {
        File file = new File("../wire-tests/src/test/proto/" + path);
        try (Source source = Okio.source((File)file);){
            String protoFile = Okio.buffer((Source)source).readUtf8();
            RepoBuilder repoBuilder = this.add(path, protoFile);
            return repoBuilder;
        }
    }

    public Schema schema() {
        try {
            return this.schemaLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Profile profile(String name) throws IOException {
        return new ProfileLoader(this.fs, name).schema(this.schema()).load();
    }

    public ProtoAdapter<Object> protoAdapter(String messageTypeName) throws IOException {
        Schema schema = this.schema();
        return schema.protoAdapter(messageTypeName, true);
    }

    public String generateCode(String typeName) throws IOException {
        return this.generateCode(typeName, null);
    }

    public String generateCode(String typeName, String profile) throws IOException {
        Schema schema = this.schema();
        JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema);
        if (profile != null) {
            javaGenerator = javaGenerator.withProfile(this.profile(profile));
        }
        Type type = schema.getType(typeName);
        TypeSpec typeSpec = javaGenerator.generateType(type);
        ClassName typeName1 = javaGenerator.generatedTypeName(type);
        return JavaFile.builder((String)typeName1.packageName(), (TypeSpec)typeSpec).build().toString();
    }

    public String generateKotlin(String typeName) {
        Schema schema = this.schema();
        KotlinGenerator kotlinGenerator = KotlinGenerator.get((Schema)schema, (boolean)false, (boolean)false);
        com.squareup.kotlinpoet.TypeSpec typeSpec = kotlinGenerator.generateType(schema.getType(typeName));
        FileSpec fileSpec = FileSpec.builder((String)"", (String)"_").addType(typeSpec).addImport("com.squareup.wire.kotlin", new String[]{"decodeMessage"}).build();
        return fileSpec.toString();
    }

    public String generateGrpcKotlin(String serviceName) {
        Schema schema = this.schema();
        KotlinGenerator grpcGenerator = KotlinGenerator.get((Schema)schema, (boolean)false, (boolean)false);
        Service service = schema.getService(serviceName);
        com.squareup.kotlinpoet.TypeSpec typeSpec = grpcGenerator.generateService(service);
        String packageName = service.type().enclosingTypeOrPackage();
        FileSpec fileSpec = FileSpec.builder((String)(packageName == null ? "" : packageName), (String)"_").addType(typeSpec).build();
        return fileSpec.toString();
    }
}

