/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.schema.CoreLoader;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Pruner;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.SchemaProtoAdapterFactory;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Schema {
    private static final Ordering<ProtoFile> PATH_ORDER = new Ordering<ProtoFile>(){

        public int compare(ProtoFile left, ProtoFile right) {
            return left.getLocation().getPath().compareTo(right.getLocation().getPath());
        }
    };
    private final ImmutableList<ProtoFile> protoFiles;
    private final ImmutableMap<String, Type> typesIndex;
    private final ImmutableMap<String, Service> servicesIndex;
    private final Map<ProtoType, ProtoFile> protoFilesIndex;

    Schema(Iterable<ProtoFile> protoFiles) {
        this.protoFiles = PATH_ORDER.immutableSortedCopy(protoFiles);
        this.protoFilesIndex = new LinkedHashMap<ProtoType, ProtoFile>();
        this.typesIndex = Schema.buildTypesIndex(protoFiles, this.protoFilesIndex);
        this.servicesIndex = Schema.buildServicesIndex(protoFiles, this.protoFilesIndex);
    }

    public ImmutableList<ProtoFile> getProtoFiles() {
        return this.protoFiles;
    }

    public ProtoFile protoFile(String path) {
        for (ProtoFile protoFile : this.protoFiles) {
            if (!protoFile.getLocation().getPath().equals(path)) continue;
            return protoFile;
        }
        return null;
    }

    public ProtoFile protoFile(ProtoType protoType) {
        return this.protoFilesIndex.get(protoType);
    }

    public Schema prune(PruningRules pruningRules) {
        return new Pruner(this, pruningRules).prune();
    }

    public Service getService(String name) {
        return (Service)this.servicesIndex.get((Object)name);
    }

    public Service getService(ProtoType protoType) {
        return this.getService(protoType.toString());
    }

    public Type getType(String name) {
        return (Type)this.typesIndex.get((Object)name);
    }

    public Type getType(ProtoType protoType) {
        return this.getType(protoType.toString());
    }

    public Field getField(ProtoMember protoMember) {
        Type type = this.getType(protoMember.getType());
        if (!(type instanceof MessageType)) {
            return null;
        }
        Field field = ((MessageType)type).field(protoMember.getMember());
        if (field == null) {
            field = ((MessageType)type).extensionField(protoMember.getMember());
        }
        return field;
    }

    public Field getField(String typeName, String memberName) {
        return this.getField(ProtoType.get(typeName), memberName);
    }

    public Field getField(ProtoType protoType, String memberName) {
        return this.getField(ProtoMember.get(protoType, memberName));
    }

    public static Schema fromFiles(Iterable<ProtoFile> sourceFiles) {
        return new Linker(CoreLoader.INSTANCE).link(sourceFiles);
    }

    static Schema fromFiles(Iterable<ProtoFile> sourceProtoFiles, Loader pathFilesLoader) {
        return new Linker(pathFilesLoader).link(sourceProtoFiles);
    }

    private static ImmutableMap<String, Type> buildTypesIndex(Iterable<ProtoFile> protoFiles, Map<ProtoType, ProtoFile> protoFilesIndex) {
        LinkedHashMap<String, Type> result = new LinkedHashMap<String, Type>();
        for (ProtoFile protoFile : protoFiles) {
            for (Type type : protoFile.getTypes()) {
                Schema.index(result, type, protoFile, protoFilesIndex);
            }
        }
        return ImmutableMap.copyOf(result);
    }

    private static void index(Map<String, Type> typesByName, Type type, ProtoFile protoFile, Map<ProtoType, ProtoFile> protoFilesIndex) {
        ProtoType protoType = type.getType();
        if (!protoFilesIndex.containsKey(protoType)) {
            protoFilesIndex.put(protoType, protoFile);
        }
        typesByName.put(type.getType().toString(), type);
        for (Type nested : type.getNestedTypes()) {
            Schema.index(typesByName, nested, protoFile, protoFilesIndex);
        }
    }

    private static ImmutableMap<String, Service> buildServicesIndex(Iterable<ProtoFile> protoFiles, Map<ProtoType, ProtoFile> protoFilesIndex) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ProtoFile protoFile : protoFiles) {
            for (Service service : protoFile.getServices()) {
                result.put((Object)service.type().toString(), (Object)service);
                protoFilesIndex.put(service.type(), protoFile);
            }
        }
        return result.build();
    }

    public ProtoAdapter<Object> protoAdapter(String typeName, boolean includeUnknown) {
        Type type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("unexpected type " + typeName);
        }
        return new SchemaProtoAdapterFactory(this, includeUnknown).get(type.getType());
    }

    boolean isExtensionField(ProtoMember protoMember) {
        Type type = this.getType(protoMember.getType());
        return type instanceof MessageType && ((MessageType)type).extensionField(protoMember.getMember()) != null;
    }
}

