/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.ProtoType;

public final class ProtoMember {
    private final ProtoType type;
    private final String member;

    private ProtoMember(ProtoType type, String member) {
        this.type = type;
        this.member = member;
    }

    public static ProtoMember get(String typeAndMember) {
        int hash = typeAndMember.indexOf(35);
        if (hash == -1) {
            throw new IllegalArgumentException("expected a '#' in " + typeAndMember);
        }
        ProtoType type = ProtoType.get(typeAndMember.substring(0, hash));
        String member = typeAndMember.substring(hash + 1);
        return new ProtoMember(type, member);
    }

    public static ProtoMember get(ProtoType type, String member) {
        return new ProtoMember(type, member);
    }

    public static ProtoMember get(ProtoType type, Field field) {
        String member = field.isExtension() ? field.qualifiedName() : field.name();
        return new ProtoMember(type, member);
    }

    public ProtoType type() {
        return this.type;
    }

    public String member() {
        return this.member;
    }

    public boolean equals(Object o) {
        return o instanceof ProtoMember && this.type.equals(((ProtoMember)o).type) && this.member.equals(((ProtoMember)o).member);
    }

    public int hashCode() {
        return this.type.hashCode() * 37 + this.member.hashCode();
    }

    public String toString() {
        return this.type + "#" + this.member;
    }
}

