/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.Util;
import com.squareup.wire.schema.internal.parser.AutoValue_ExtendElement;
import com.squareup.wire.schema.internal.parser.FieldElement;

public abstract class ExtendElement {
    public static Builder builder(Location location) {
        return new AutoValue_ExtendElement.Builder().documentation("").fields((ImmutableList<FieldElement>)ImmutableList.of()).location(location);
    }

    public abstract Location location();

    public abstract String name();

    public abstract String documentation();

    public abstract ImmutableList<FieldElement> fields();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append("extend ").append(this.name()).append(" {");
        if (!this.fields().isEmpty()) {
            builder.append('\n');
            for (FieldElement field : this.fields()) {
                Util.appendIndented(builder, field.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder name(String var1);

        public Builder documentation(String var1);

        public Builder fields(ImmutableList<FieldElement> var1);

        public ExtendElement build();
    }
}

