/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;

final class AutoValue_ServiceElement
extends ServiceElement {
    private final Location location;
    private final String name;
    private final String documentation;
    private final ImmutableList<RpcElement> rpcs;
    private final ImmutableList<OptionElement> options;

    private AutoValue_ServiceElement(Location location, String name, String documentation, ImmutableList<RpcElement> rpcs, ImmutableList<OptionElement> options) {
        if (location == null) {
            throw new NullPointerException("Null location");
        }
        this.location = location;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        if (documentation == null) {
            throw new NullPointerException("Null documentation");
        }
        this.documentation = documentation;
        if (rpcs == null) {
            throw new NullPointerException("Null rpcs");
        }
        this.rpcs = rpcs;
        if (options == null) {
            throw new NullPointerException("Null options");
        }
        this.options = options;
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public ImmutableList<RpcElement> rpcs() {
        return this.rpcs;
    }

    @Override
    public ImmutableList<OptionElement> options() {
        return this.options;
    }

    public String toString() {
        return "ServiceElement{location=" + this.location + ", name=" + this.name + ", documentation=" + this.documentation + ", rpcs=" + this.rpcs + ", options=" + this.options + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ServiceElement) {
            ServiceElement that = (ServiceElement)o;
            return this.location.equals(that.location()) && this.name.equals(that.name()) && this.documentation.equals(that.documentation()) && this.rpcs.equals(that.rpcs()) && this.options.equals(that.options());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.documentation.hashCode();
        h *= 1000003;
        h ^= this.rpcs.hashCode();
        h *= 1000003;
        return h ^= this.options.hashCode();
    }

    static final class Builder
    implements ServiceElement.Builder {
        private Location location;
        private String name;
        private String documentation;
        private ImmutableList<RpcElement> rpcs;
        private ImmutableList<OptionElement> options;

        Builder() {
        }

        Builder(ServiceElement source) {
            this.location = source.location();
            this.name = source.name();
            this.documentation = source.documentation();
            this.rpcs = source.rpcs();
            this.options = source.options();
        }

        @Override
        public ServiceElement.Builder location(Location location) {
            this.location = location;
            return this;
        }

        @Override
        public ServiceElement.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ServiceElement.Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        @Override
        public ServiceElement.Builder rpcs(ImmutableList<RpcElement> rpcs) {
            this.rpcs = rpcs;
            return this;
        }

        @Override
        public ServiceElement.Builder options(ImmutableList<OptionElement> options) {
            this.options = options;
            return this;
        }

        @Override
        public ServiceElement build() {
            String missing = "";
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.documentation == null) {
                missing = missing + " documentation";
            }
            if (this.rpcs == null) {
                missing = missing + " rpcs";
            }
            if (this.options == null) {
                missing = missing + " options";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ServiceElement(this.location, this.name, this.documentation, this.rpcs, this.options);
        }
    }
}

