/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.OptionElement;

final class AutoValue_EnumConstantElement
extends EnumConstantElement {
    private final Location location;
    private final String name;
    private final int tag;
    private final String documentation;
    private final ImmutableList<OptionElement> options;

    private AutoValue_EnumConstantElement(Location location, String name, int tag, String documentation, ImmutableList<OptionElement> options) {
        if (location == null) {
            throw new NullPointerException("Null location");
        }
        this.location = location;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        this.tag = tag;
        if (documentation == null) {
            throw new NullPointerException("Null documentation");
        }
        this.documentation = documentation;
        if (options == null) {
            throw new NullPointerException("Null options");
        }
        this.options = options;
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int tag() {
        return this.tag;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public ImmutableList<OptionElement> options() {
        return this.options;
    }

    public String toString() {
        return "EnumConstantElement{location=" + this.location + ", name=" + this.name + ", tag=" + this.tag + ", documentation=" + this.documentation + ", options=" + this.options + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EnumConstantElement) {
            EnumConstantElement that = (EnumConstantElement)o;
            return this.location.equals(that.location()) && this.name.equals(that.name()) && this.tag == that.tag() && this.documentation.equals(that.documentation()) && this.options.equals(that.options());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.tag;
        h *= 1000003;
        h ^= this.documentation.hashCode();
        h *= 1000003;
        return h ^= this.options.hashCode();
    }

    static final class Builder
    implements EnumConstantElement.Builder {
        private Location location;
        private String name;
        private Integer tag;
        private String documentation;
        private ImmutableList<OptionElement> options;

        Builder() {
        }

        Builder(EnumConstantElement source) {
            this.location = source.location();
            this.name = source.name();
            this.tag = source.tag();
            this.documentation = source.documentation();
            this.options = source.options();
        }

        @Override
        public EnumConstantElement.Builder location(Location location) {
            this.location = location;
            return this;
        }

        @Override
        public EnumConstantElement.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public EnumConstantElement.Builder tag(int tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public EnumConstantElement.Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        @Override
        public EnumConstantElement.Builder options(ImmutableList<OptionElement> options) {
            this.options = options;
            return this;
        }

        @Override
        public EnumConstantElement build() {
            String missing = "";
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.tag == null) {
                missing = missing + " tag";
            }
            if (this.documentation == null) {
                missing = missing + " documentation";
            }
            if (this.options == null) {
                missing = missing + " options";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EnumConstantElement(this.location, this.name, this.tag, this.documentation, this.options);
        }
    }
}

