/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

final class Pruner {
    final Schema schema;
    final IdentifierSet identifierSet;
    final MarkSet marks;
    final Deque<Object> queue;

    public Pruner(Schema schema, IdentifierSet identifierSet) {
        this.schema = schema;
        this.identifierSet = identifierSet;
        this.marks = new MarkSet(identifierSet);
        this.queue = new ArrayDeque<Object>();
    }

    public Schema prune() {
        this.markRoots();
        this.markReachable();
        ImmutableList.Builder retained = ImmutableList.builder();
        for (ProtoFile protoFile : this.schema.protoFiles()) {
            retained.add((Object)protoFile.retainAll(this.schema, this.marks));
        }
        return new Schema((Iterable<ProtoFile>)retained.build());
    }

    private void markRoots() {
        for (ProtoFile protoFile : this.schema.protoFiles()) {
            this.markRoots(protoFile);
        }
    }

    private void markRoots(ProtoFile protoFile) {
        for (Type type : protoFile.types()) {
            this.markRoots(type);
        }
        for (Service service : protoFile.services()) {
            this.markRoots(service);
        }
    }

    private void markRoots(Type type) {
        ProtoType protoType = type.type();
        if (this.identifierSet.includes(protoType)) {
            this.marks.root(protoType);
            this.queue.add(protoType);
        } else if (type instanceof MessageType) {
            for (Field field : ((MessageType)type).fieldsAndOneOfFields()) {
                this.markRoots(ProtoMember.get(protoType, field.name()));
            }
        } else if (type instanceof EnumType) {
            for (EnumConstant enumConstant : ((EnumType)type).constants()) {
                this.markRoots(ProtoMember.get(protoType, enumConstant.name()));
            }
        } else {
            throw new AssertionError();
        }
        for (Type nested : type.nestedTypes()) {
            this.markRoots(nested);
        }
    }

    private void markRoots(Service service) {
        ProtoType protoType = service.type();
        if (this.identifierSet.includes(protoType)) {
            this.marks.root(protoType);
            this.queue.add(protoType);
        } else {
            for (Rpc rpc : service.rpcs()) {
                this.markRoots(ProtoMember.get(protoType, rpc.name()));
            }
        }
    }

    private void markRoots(ProtoMember protoMember) {
        if (this.identifierSet.includes(protoMember)) {
            this.marks.root(protoMember);
            this.queue.add(protoMember);
        }
    }

    private void markReachable() {
        Object root;
        while ((root = this.queue.poll()) != null) {
            if (root instanceof ProtoMember) {
                Rpc rpc;
                Service service;
                EnumConstant constant;
                ProtoMember protoMember = (ProtoMember)root;
                this.mark(protoMember.type());
                String member = ((ProtoMember)root).member();
                Type type = this.schema.getType(protoMember.type());
                if (type instanceof MessageType) {
                    Field field = ((MessageType)type).field(member);
                    if (field == null) {
                        field = ((MessageType)type).extensionField(member);
                    }
                    if (field != null) {
                        this.markField(type.type(), field);
                        continue;
                    }
                } else if (type instanceof EnumType && (constant = ((EnumType)type).constant(member)) != null) {
                    this.markOptions(constant.options());
                    continue;
                }
                if ((service = this.schema.getService(protoMember.type())) != null && (rpc = service.rpc(member)) != null) {
                    this.markRpc(service.type(), rpc);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected member: " + root);
            }
            if (root instanceof ProtoType) {
                ProtoType protoType = (ProtoType)root;
                if (protoType.isScalar()) continue;
                Type type = this.schema.getType(protoType);
                if (type != null) {
                    this.markType(type);
                    continue;
                }
                Service service = this.schema.getService(protoType);
                if (service != null) {
                    this.markService(service);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected type: " + root);
            }
            throw new AssertionError();
        }
    }

    private void mark(ProtoType type) {
        if (type.isMap()) {
            type = type.valueType();
        }
        if (this.marks.mark(type)) {
            this.queue.add(type);
        }
    }

    private void mark(ProtoMember protoMember) {
        if (this.marks.mark(protoMember)) {
            this.queue.add(protoMember);
        }
    }

    private void markType(Type type) {
        this.markOptions(type.options());
        if (this.marks.containsAllMembers(type.type())) {
            if (type instanceof MessageType) {
                this.markMessage((MessageType)type);
            } else if (type instanceof EnumType) {
                this.markEnum((EnumType)type);
            }
        }
    }

    private void markMessage(MessageType message) {
        this.markFields(message.type(), message.fields());
        for (OneOf oneOf : message.oneOfs()) {
            this.markFields(message.type(), oneOf.fields());
        }
    }

    private void markEnum(EnumType wireEnum) {
        this.markOptions(wireEnum.options());
        if (this.marks.containsAllMembers(wireEnum.type())) {
            for (EnumConstant constant : wireEnum.constants()) {
                if (!this.marks.contains(ProtoMember.get(wireEnum.type(), constant.name()))) continue;
                this.markOptions(constant.options());
            }
        }
    }

    private void markFields(ProtoType declaringType, ImmutableList<Field> fields) {
        for (Field field : fields) {
            this.markField(declaringType, field);
        }
    }

    private void markField(ProtoType declaringType, Field field) {
        if (this.marks.contains(ProtoMember.get(declaringType, field.name()))) {
            this.markOptions(field.options());
            this.mark(field.type());
        }
    }

    private void markOptions(Options options) {
        for (Map.Entry entry : options.fields().entries()) {
            this.mark((ProtoMember)entry.getValue());
        }
    }

    private void markService(Service service) {
        this.markOptions(service.options());
        if (this.marks.containsAllMembers(service.type())) {
            for (Rpc rpc : service.rpcs()) {
                this.markRpc(service.type(), rpc);
            }
        }
    }

    private void markRpc(ProtoType declaringType, Rpc rpc) {
        if (this.marks.contains(ProtoMember.get(declaringType, rpc.name()))) {
            this.markOptions(rpc.options());
            this.mark(rpc.requestType());
            this.mark(rpc.responseType());
        }
    }
}

