/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import java.util.Collection;
import java.util.List;

public final class ProtoFile {
    static final ProtoMember JAVA_PACKAGE = ProtoMember.get(Options.FILE_OPTIONS, "java_package");
    private final Location location;
    private final ImmutableList<String> imports;
    private final ImmutableList<String> publicImports;
    private final String packageName;
    private final ImmutableList<Type> types;
    private final ImmutableList<Service> services;
    private final ImmutableList<Extend> extendList;
    private final Options options;
    private final Syntax syntax;
    private Object javaPackage;

    private ProtoFile(Location location, ImmutableList<String> imports, ImmutableList<String> publicImports, String packageName, ImmutableList<Type> types, ImmutableList<Service> services, ImmutableList<Extend> extendList, Options options, Syntax syntax) {
        this.location = location;
        this.imports = imports;
        this.publicImports = publicImports;
        this.packageName = packageName;
        this.types = types;
        this.services = services;
        this.extendList = extendList;
        this.options = options;
        this.syntax = syntax;
    }

    static ProtoFile get(ProtoFileElement protoFileElement) {
        String packageName = protoFileElement.packageName();
        ImmutableList<Type> types = Type.fromElements(packageName, protoFileElement.types());
        ImmutableList<Service> services = Service.fromElements(packageName, protoFileElement.services());
        ImmutableList<Extend> wireExtends = Extend.fromElements(packageName, protoFileElement.extendDeclarations());
        Options options = new Options(Options.FILE_OPTIONS, (List<OptionElement>)protoFileElement.options());
        return new ProtoFile(protoFileElement.location(), protoFileElement.imports(), protoFileElement.publicImports(), packageName, types, services, wireExtends, options, protoFileElement.syntax());
    }

    ProtoFileElement toElement() {
        return ProtoFileElement.builder(this.location).imports(this.imports).publicImports(this.publicImports).packageName(this.packageName).types(Type.toElements(this.types)).services(Service.toElements(this.services)).extendDeclarations(Extend.toElements(this.extendList)).options((Collection<OptionElement>)this.options.toElements()).syntax(this.syntax).build();
    }

    public Location location() {
        return this.location;
    }

    ImmutableList<String> imports() {
        return this.imports;
    }

    ImmutableList<String> publicImports() {
        return this.publicImports;
    }

    public String name() {
        String result = this.location().path();
        int slashIndex = result.lastIndexOf(47);
        if (slashIndex != -1) {
            result = result.substring(slashIndex + 1);
        }
        if (result.endsWith(".proto")) {
            result = result.substring(0, result.length() - ".proto".length());
        }
        return result;
    }

    public String packageName() {
        return this.packageName;
    }

    public String javaPackage() {
        return this.javaPackage != null ? String.valueOf(this.javaPackage) : null;
    }

    public ImmutableList<Type> types() {
        return this.types;
    }

    public ImmutableList<Service> services() {
        return this.services;
    }

    ImmutableList<Extend> extendList() {
        return this.extendList;
    }

    public Options options() {
        return this.options;
    }

    ProtoFile retainAll(Schema schema, MarkSet markSet) {
        ImmutableList.Builder retainedTypes = ImmutableList.builder();
        for (Type type : this.types) {
            Type retainedType = type.retainAll(schema, markSet);
            if (retainedType == null) continue;
            retainedTypes.add((Object)retainedType);
        }
        ImmutableList.Builder retainedServices = ImmutableList.builder();
        for (Service service : this.services) {
            Service retainedService = service.retainAll(schema, markSet);
            if (retainedService == null) continue;
            retainedServices.add((Object)retainedService);
        }
        ProtoFile result = new ProtoFile(this.location, this.imports, this.publicImports, this.packageName, (ImmutableList<Type>)retainedTypes.build(), (ImmutableList<Service>)retainedServices.build(), this.extendList, this.options.retainAll(schema, markSet), this.syntax);
        result.javaPackage = this.javaPackage;
        return result;
    }

    void linkOptions(Linker linker) {
        this.options.link(linker);
        this.javaPackage = this.options().get(JAVA_PACKAGE);
    }

    public String toString() {
        return this.location().path();
    }

    public static enum Syntax {
        PROTO_2("proto2"),
        PROTO_3("proto3");

        private final String string;

        private Syntax(String string2) {
            this.string = string2;
        }

        public static Syntax get(String string) {
            for (Syntax syntax : Syntax.values()) {
                if (!syntax.string.equals(string)) continue;
                return syntax;
            }
            throw new IllegalArgumentException("unexpected syntax: " + string);
        }

        public String toString() {
            return this.string;
        }
    }
}

