/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.GroupElement;

final class AutoValue_GroupElement
extends GroupElement {
    private final Field.Label label;
    private final String name;
    private final int tag;
    private final String documentation;
    private final ImmutableList<FieldElement> fields;

    private AutoValue_GroupElement(Field.Label label, String name, int tag, String documentation, ImmutableList<FieldElement> fields) {
        this.label = label;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        this.tag = tag;
        if (documentation == null) {
            throw new NullPointerException("Null documentation");
        }
        this.documentation = documentation;
        if (fields == null) {
            throw new NullPointerException("Null fields");
        }
        this.fields = fields;
    }

    @Override
    public Field.Label label() {
        return this.label;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int tag() {
        return this.tag;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public ImmutableList<FieldElement> fields() {
        return this.fields;
    }

    public String toString() {
        return "GroupElement{label=" + (Object)((Object)this.label) + ", " + "name=" + this.name + ", " + "tag=" + this.tag + ", " + "documentation=" + this.documentation + ", " + "fields=" + this.fields + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GroupElement) {
            GroupElement that = (GroupElement)o;
            return (this.label == null ? that.label() == null : this.label.equals((Object)that.label())) && this.name.equals(that.name()) && this.tag == that.tag() && this.documentation.equals(that.documentation()) && this.fields.equals(that.fields());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.label == null ? 0 : this.label.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.tag;
        h *= 1000003;
        h ^= this.documentation.hashCode();
        h *= 1000003;
        return h ^= this.fields.hashCode();
    }

    static final class Builder
    implements GroupElement.Builder {
        private Field.Label label;
        private String name;
        private Integer tag;
        private String documentation;
        private ImmutableList<FieldElement> fields;

        Builder() {
        }

        Builder(GroupElement source) {
            this.label = source.label();
            this.name = source.name();
            this.tag = source.tag();
            this.documentation = source.documentation();
            this.fields = source.fields();
        }

        @Override
        public GroupElement.Builder label(Field.Label label) {
            this.label = label;
            return this;
        }

        @Override
        public GroupElement.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public GroupElement.Builder tag(int tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public GroupElement.Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        @Override
        public GroupElement.Builder fields(ImmutableList<FieldElement> fields) {
            this.fields = fields;
            return this;
        }

        @Override
        public GroupElement build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.tag == null) {
                missing = missing + " tag";
            }
            if (this.documentation == null) {
                missing = missing + " documentation";
            }
            if (this.fields == null) {
                missing = missing + " fields";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GroupElement(this.label, this.name, this.tag, this.documentation, this.fields);
        }
    }
}

