/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.OptionElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Options {
    public static final ProtoType FILE_OPTIONS = ProtoType.get("google.protobuf.FileOptions");
    public static final ProtoType MESSAGE_OPTIONS = ProtoType.get("google.protobuf.MessageOptions");
    public static final ProtoType FIELD_OPTIONS = ProtoType.get("google.protobuf.FieldOptions");
    public static final ProtoType ENUM_OPTIONS = ProtoType.get("google.protobuf.EnumOptions");
    public static final ProtoType ENUM_VALUE_OPTIONS = ProtoType.get("google.protobuf.EnumValueOptions");
    public static final ProtoType SERVICE_OPTIONS = ProtoType.get("google.protobuf.ServiceOptions");
    public static final ProtoType METHOD_OPTIONS = ProtoType.get("google.protobuf.MethodOptions");
    private final ProtoType optionType;
    private final ImmutableList<OptionElement> optionElements;
    private ImmutableMap<ProtoMember, Object> map;

    public Options(ProtoType optionType, List<OptionElement> elements) {
        this.optionType = optionType;
        this.optionElements = ImmutableList.copyOf(elements);
    }

    public Map<ProtoMember, Object> map() {
        return this.map;
    }

    public Object get(ProtoMember protoMember) {
        Preconditions.checkNotNull((Object)protoMember, (Object)"protoMember");
        return this.map.get((Object)protoMember);
    }

    public boolean optionMatches(String namePattern, String valuePattern) {
        Matcher nameMatcher = Pattern.compile(namePattern).matcher("");
        Matcher valueMatcher = Pattern.compile(valuePattern).matcher("");
        for (Map.Entry entry : this.map.entrySet()) {
            if (!nameMatcher.reset(((ProtoMember)entry.getKey()).member()).matches() || !valueMatcher.reset(String.valueOf(entry.getValue())).matches()) continue;
            return true;
        }
        return false;
    }

    ImmutableList<OptionElement> toElements() {
        return this.optionElements;
    }

    void link(Linker linker) {
        ImmutableMap<ProtoMember, Object> map = ImmutableMap.of();
        for (OptionElement option : this.optionElements) {
            Map<ProtoMember, Object> canonicalOption = this.canonicalizeOption(linker, this.optionType, option);
            if (canonicalOption == null) continue;
            map = this.union(linker, (Map<ProtoMember, Object>)map, canonicalOption);
        }
        this.map = map;
    }

    Map<ProtoMember, Object> canonicalizeOption(Linker linker, ProtoType extensionType, OptionElement option) {
        LinkedHashMap<ProtoMember, Object> result;
        String[] path;
        Type type = linker.get(extensionType);
        if (!(type instanceof MessageType)) {
            return null;
        }
        MessageType messageType = (MessageType)type;
        Field field = messageType.field(option.name());
        if (field != null) {
            path = new String[]{option.name()};
        } else {
            Map<String, Field> extensionsForType = messageType.extensionFieldsMap();
            path = Options.resolveFieldPath(option.name(), extensionsForType.keySet());
            String packageName = linker.packageName();
            if (path == null && packageName != null) {
                path = Options.resolveFieldPath(packageName + "." + option.name(), extensionsForType.keySet());
            }
            if (path == null) {
                return null;
            }
            field = extensionsForType.get(path[0]);
        }
        LinkedHashMap<ProtoMember, Object> last = result = new LinkedHashMap<ProtoMember, Object>();
        ProtoType lastProtoType = messageType.type();
        for (int i = 1; i < path.length; ++i) {
            LinkedHashMap nested = new LinkedHashMap();
            last.put(ProtoMember.get(lastProtoType, field), nested);
            lastProtoType = field.type();
            last = nested;
            field = linker.dereference(field, path[i]);
            if (field != null) continue;
            return null;
        }
        last.put(ProtoMember.get(lastProtoType, field), this.canonicalizeValue(linker, field, option.value()));
        return result;
    }

    static String[] resolveFieldPath(String name, Set<String> fullyQualifiedNames) {
        for (int i = 0; i < name.length(); ++i) {
            String candidate;
            if ((i = name.indexOf(46, i)) == -1) {
                i = name.length();
            }
            if (!fullyQualifiedNames.contains(candidate = name.substring(0, i))) continue;
            String[] path = name.substring(i).split("\\.", -1);
            path[0] = name.substring(0, i);
            return path;
        }
        return null;
    }

    private Object canonicalizeValue(Linker linker, Field context, Object value) {
        if (value instanceof OptionElement) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            OptionElement option = (OptionElement)value;
            Field field = linker.dereference(context, option.name());
            if (field == null) {
                linker.addError("unable to resolve option %s on %s", option.name(), context.type());
            } else {
                ProtoMember protoMember = ProtoMember.get(context.type(), field);
                result.put((Object)protoMember, this.canonicalizeValue(linker, field, option.value()));
            }
            return this.coerceValueForField(context, result.build());
        }
        if (value instanceof Map) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String name = (String)entry.getKey();
                Field field = linker.dereference(context, name);
                if (field == null) {
                    linker.addError("unable to resolve option %s on %s", name, context.type());
                    continue;
                }
                ProtoMember protoMember = ProtoMember.get(context.type(), field);
                result.put((Object)protoMember, this.canonicalizeValue(linker, field, entry.getValue()));
            }
            return this.coerceValueForField(context, result.build());
        }
        if (value instanceof List) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (Object element : (List)value) {
                result.addAll((Iterable)((List)this.canonicalizeValue(linker, context, element)));
            }
            return this.coerceValueForField(context, result.build());
        }
        if (value instanceof String) {
            return this.coerceValueForField(context, value);
        }
        throw new IllegalArgumentException("Unexpected option value: " + value);
    }

    private Object coerceValueForField(Field context, Object value) {
        if (context.isRepeated()) {
            return value instanceof List ? value : ImmutableList.of((Object)value);
        }
        return value instanceof List ? Iterables.getOnlyElement((Iterable)((List)value)) : value;
    }

    private Object union(Linker linker, Object a, Object b) {
        if (a instanceof List) {
            return this.union((List)a, (List)b);
        }
        if (a instanceof Map) {
            return this.union(linker, (Map)a, (Map)b);
        }
        linker.addError("conflicting options: %s, %s", a, b);
        return a;
    }

    private ImmutableMap<ProtoMember, Object> union(Linker linker, Map<ProtoMember, Object> a, Map<ProtoMember, Object> b) {
        LinkedHashMap<ProtoMember, Object> result = new LinkedHashMap<ProtoMember, Object>(a);
        for (Map.Entry<ProtoMember, Object> entry : b.entrySet()) {
            Object aValue = result.get(entry.getKey());
            Object bValue = entry.getValue();
            Object union = aValue != null ? this.union(linker, aValue, bValue) : bValue;
            result.put(entry.getKey(), union);
        }
        return ImmutableMap.copyOf(result);
    }

    private ImmutableList<Object> union(List<?> a, List<?> b) {
        return ImmutableList.builder().addAll(a).addAll(b).build();
    }

    Multimap<ProtoType, ProtoMember> fields() {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        this.gatherFields((Multimap<ProtoType, ProtoMember>)result, this.optionType, this.map);
        return result;
    }

    private void gatherFields(Multimap<ProtoType, ProtoMember> sink, ProtoType type, Object o) {
        block3: {
            block2: {
                if (!(o instanceof Map)) break block2;
                for (Map.Entry entry : ((Map)o).entrySet()) {
                    ProtoMember protoMember = (ProtoMember)entry.getKey();
                    sink.put((Object)type, (Object)protoMember);
                    this.gatherFields(sink, protoMember.type(), entry.getValue());
                }
                break block3;
            }
            if (!(o instanceof List)) break block3;
            for (Object e : (List)o) {
                this.gatherFields(sink, type, e);
            }
        }
    }

    Options retainAll(Schema schema, MarkSet markSet) {
        if (this.map.isEmpty()) {
            return this;
        }
        Options result = new Options(this.optionType, (List<OptionElement>)this.optionElements);
        Object mapOrNull = this.retainAll(schema, markSet, this.optionType, this.map);
        result.map = mapOrNull != null ? (ImmutableMap)mapOrNull : ImmutableMap.of();
        return result;
    }

    private Object retainAll(Schema schema, MarkSet markSet, ProtoType type, Object o) {
        if (!markSet.contains(type)) {
            return null;
        }
        if (o instanceof Map) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Field field;
                Object retainedValue;
                ProtoMember protoMember = (ProtoMember)entry.getKey();
                if (!markSet.contains(protoMember) || (retainedValue = this.retainAll(schema, markSet, (field = schema.getField(protoMember)).type(), entry.getValue())) == null) continue;
                builder.put((Object)protoMember, retainedValue);
            }
            ImmutableMap map = builder.build();
            return !map.isEmpty() ? map : null;
        }
        if (o instanceof List) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object value : (List)o) {
                Object retainedValue = this.retainAll(schema, markSet, type, value);
                if (retainedValue == null) continue;
                builder.add(retainedValue);
            }
            ImmutableList list = builder.build();
            return !list.isEmpty() ? list : null;
        }
        return o;
    }
}

