/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.Util;
import com.squareup.wire.schema.internal.parser.AutoValue_MessageElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.TypeElement;

public abstract class MessageElement
implements TypeElement {
    public static Builder builder(Location location) {
        return new AutoValue_MessageElement.Builder().location(location).documentation("").fields((ImmutableList<FieldElement>)ImmutableList.of()).oneOfs((ImmutableList<OneOfElement>)ImmutableList.of()).nestedTypes((ImmutableList<TypeElement>)ImmutableList.of()).extensions((ImmutableList<ExtensionsElement>)ImmutableList.of()).options((ImmutableList<OptionElement>)ImmutableList.of());
    }

    @Override
    public abstract Location location();

    @Override
    public abstract String name();

    @Override
    public abstract String documentation();

    @Override
    public abstract ImmutableList<TypeElement> nestedTypes();

    @Override
    public abstract ImmutableList<OptionElement> options();

    public abstract ImmutableList<FieldElement> fields();

    public abstract ImmutableList<OneOfElement> oneOfs();

    public abstract ImmutableList<ExtensionsElement> extensions();

    @Override
    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append("message ").append(this.name()).append(" {");
        if (!this.options().isEmpty()) {
            builder.append('\n');
            for (OptionElement option : this.options()) {
                Util.appendIndented(builder, option.toSchemaDeclaration());
            }
        }
        if (!this.fields().isEmpty()) {
            builder.append('\n');
            for (FieldElement field : this.fields()) {
                Util.appendIndented(builder, field.toSchema());
            }
        }
        if (!this.oneOfs().isEmpty()) {
            builder.append('\n');
            for (OneOfElement oneOf : this.oneOfs()) {
                Util.appendIndented(builder, oneOf.toSchema());
            }
        }
        if (!this.extensions().isEmpty()) {
            builder.append('\n');
            for (ExtensionsElement extension : this.extensions()) {
                Util.appendIndented(builder, extension.toSchema());
            }
        }
        if (!this.nestedTypes().isEmpty()) {
            builder.append('\n');
            for (TypeElement type : this.nestedTypes()) {
                Util.appendIndented(builder, type.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder name(String var1);

        public Builder documentation(String var1);

        public Builder fields(ImmutableList<FieldElement> var1);

        public Builder oneOfs(ImmutableList<OneOfElement> var1);

        public Builder nestedTypes(ImmutableList<TypeElement> var1);

        public Builder extensions(ImmutableList<ExtensionsElement> var1);

        public Builder options(ImmutableList<OptionElement> var1);

        public MessageElement build();
    }
}

