/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.RpcElement;

public final class Rpc {
    private final RpcElement element;
    private final Options options;
    private ProtoType requestType;
    private ProtoType responseType;

    Rpc(RpcElement element, Options options) {
        this.element = element;
        this.options = options;
    }

    public Location location() {
        return this.element.location();
    }

    public String name() {
        return this.element.name();
    }

    public String documentation() {
        return this.element.documentation();
    }

    public ProtoType requestType() {
        return this.requestType;
    }

    public ProtoType responseType() {
        return this.responseType;
    }

    public Options options() {
        return this.options;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.requestType = linker.resolveMessageType(this.element.requestType());
        this.responseType = linker.resolveMessageType(this.element.responseType());
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        this.options.link(linker);
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        linker.validateImport(this.location(), this.requestType);
        linker.validateImport(this.location(), this.responseType);
    }

    Rpc retainAll(Schema schema, MarkSet markSet) {
        if (!markSet.contains(this.requestType) || !markSet.contains(this.responseType)) {
            return null;
        }
        Rpc result = new Rpc(this.element, this.options.retainAll(schema, markSet));
        result.requestType = this.requestType;
        result.responseType = this.responseType;
        return result;
    }
}

