/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.List;
import java.util.NavigableSet;

public final class ProtoFile {
    private final ProtoFileElement element;
    private final ImmutableList<Type> types;
    private final ImmutableList<Service> services;
    private final ImmutableList<Extend> extendList;
    private final Options options;

    private ProtoFile(ProtoFileElement element, ImmutableList<Type> types, ImmutableList<Service> services, ImmutableList<Extend> extendList, Options options) {
        this.element = element;
        this.types = types;
        this.services = services;
        this.extendList = extendList;
        this.options = options;
    }

    static ProtoFile get(ProtoFileElement protoFileElement) {
        String packageName = protoFileElement.packageName();
        ImmutableList.Builder types = ImmutableList.builder();
        for (TypeElement type : protoFileElement.types()) {
            ProtoType protoType = ProtoType.get(packageName, type.name());
            types.add((Object)Type.get(packageName, protoType, type));
        }
        ImmutableList.Builder services = ImmutableList.builder();
        for (ServiceElement service : protoFileElement.services()) {
            ProtoType protoType = ProtoType.get(packageName, service.name());
            services.add((Object)Service.get(protoType, service));
        }
        ImmutableList.Builder wireExtends = ImmutableList.builder();
        for (ExtendElement extend : protoFileElement.extendDeclarations()) {
            wireExtends.add((Object)new Extend(packageName, extend));
        }
        Options options = new Options(Options.FILE_OPTIONS, (List<OptionElement>)protoFileElement.options());
        return new ProtoFile(protoFileElement, (ImmutableList<Type>)types.build(), (ImmutableList<Service>)services.build(), (ImmutableList<Extend>)wireExtends.build(), options);
    }

    public Location location() {
        return this.element.location();
    }

    ImmutableList<String> imports() {
        return this.element.imports();
    }

    ImmutableList<String> publicImports() {
        return this.element.publicImports();
    }

    public String name() {
        String result = this.location().path();
        int slashIndex = result.lastIndexOf(47);
        if (slashIndex != -1) {
            result = result.substring(slashIndex + 1);
        }
        if (result.endsWith(".proto")) {
            result = result.substring(0, result.length() - ".proto".length());
        }
        return result;
    }

    public String packageName() {
        return this.element.packageName();
    }

    public ImmutableList<Type> types() {
        return this.types;
    }

    public ImmutableList<Service> services() {
        return this.services;
    }

    ImmutableList<Extend> extendList() {
        return this.extendList;
    }

    public Options options() {
        return this.options;
    }

    ProtoFile retainAll(NavigableSet<String> identifiers) {
        ImmutableList.Builder retainedTypes = ImmutableList.builder();
        for (Type type : this.types) {
            Type retainedType = type.retainAll(identifiers);
            if (retainedType == null) continue;
            retainedTypes.add((Object)retainedType);
        }
        ImmutableList.Builder retainedServices = ImmutableList.builder();
        for (Service service : this.services) {
            Service retainedService = service.retainAll(identifiers);
            if (retainedService == null) continue;
            retainedServices.add((Object)retainedService);
        }
        return new ProtoFile(this.element, (ImmutableList<Type>)retainedTypes.build(), (ImmutableList<Service>)retainedServices.build(), this.extendList, this.options);
    }

    public String toString() {
        return this.location().path();
    }

    public static enum Syntax {
        PROTO_2("proto2"),
        PROTO_3("proto3");

        private final String string;

        private Syntax(String string2) {
            this.string = string2;
        }

        public static Syntax get(String string) {
            for (Syntax syntax : Syntax.values()) {
                if (!syntax.string.equals(string)) continue;
                return syntax;
            }
            throw new IllegalArgumentException("unexpected syntax: " + string);
        }

        public String toString() {
            return this.string;
        }
    }
}

