/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Pruner;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.MessageElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;

public final class MessageType
extends Type {
    private final ProtoType protoType;
    private final MessageElement element;
    private final ImmutableList<Field> declaredFields;
    private final List<Field> extensionFields;
    private final ImmutableList<OneOf> oneOfs;
    private final ImmutableList<Type> nestedTypes;
    private final ImmutableList<Extensions> extensionsList;
    private final Options options;

    MessageType(ProtoType protoType, MessageElement element, ImmutableList<Field> declaredFields, List<Field> extensionFields, ImmutableList<OneOf> oneOfs, ImmutableList<Type> nestedTypes, ImmutableList<Extensions> extensionsList, Options options) {
        this.protoType = protoType;
        this.element = element;
        this.declaredFields = declaredFields;
        this.extensionFields = extensionFields;
        this.oneOfs = oneOfs;
        this.nestedTypes = nestedTypes;
        this.extensionsList = extensionsList;
        this.options = (Options)Preconditions.checkNotNull((Object)options);
    }

    @Override
    public Location location() {
        return this.element.location();
    }

    @Override
    public ProtoType name() {
        return this.protoType;
    }

    @Override
    public String documentation() {
        return this.element.documentation();
    }

    @Override
    public ImmutableList<Type> nestedTypes() {
        return this.nestedTypes;
    }

    @Override
    public Options options() {
        return this.options;
    }

    public ImmutableList<Field> fields() {
        return ImmutableList.builder().addAll(this.declaredFields).addAll(this.extensionFields).build();
    }

    public ImmutableList<Field> extensionFields() {
        return ImmutableList.copyOf(this.extensionFields);
    }

    public ImmutableList<Field> getRequiredFields() {
        ImmutableList.Builder required = ImmutableList.builder();
        for (Field field : this.fieldsAndOneOfFields()) {
            if (!field.isRequired()) continue;
            required.add((Object)field);
        }
        return required.build();
    }

    public ImmutableList<Field> fieldsAndOneOfFields() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(this.declaredFields);
        result.addAll(this.extensionFields);
        for (OneOf oneOf : this.oneOfs) {
            result.addAll(oneOf.fields());
        }
        return result.build();
    }

    public Field field(String name) {
        for (Field field : this.declaredFields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        for (Field field : this.extensionFields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public Field field(int tag) {
        for (Field field : this.declaredFields) {
            if (field.tag() != tag) continue;
            return field;
        }
        for (Field field : this.extensionFields) {
            if (field.tag() != tag) continue;
            return field;
        }
        return null;
    }

    public ImmutableList<OneOf> oneOfs() {
        return this.oneOfs;
    }

    public ImmutableList<Extensions> extensions() {
        return this.extensionsList;
    }

    Map<String, Field> extensionFieldsMap() {
        LinkedHashMap<String, Field> extensionsForType = new LinkedHashMap<String, Field>();
        for (Field field : this.extensionFields) {
            extensionsForType.put(field.qualifiedName(), field);
        }
        return extensionsForType;
    }

    @Override
    void validate(Linker linker) {
        linker = linker.withContext(this);
        linker.validateFields((Iterable<Field>)this.fieldsAndOneOfFields());
        linker.validateEnumConstantNameUniqueness((Iterable<Type>)this.nestedTypes);
        for (Field field : this.fieldsAndOneOfFields()) {
            field.validate(linker);
        }
        for (Type type : this.nestedTypes) {
            type.validate(linker);
        }
        for (Extensions extensions : this.extensionsList) {
            extensions.validate(linker);
        }
    }

    @Override
    void link(Linker linker) {
        linker = linker.withContext(this);
        for (Field field : this.declaredFields) {
            field.link(linker);
        }
        for (Field field : this.extensionFields) {
            field.link(linker);
        }
        for (OneOf oneOf : this.oneOfs) {
            oneOf.link(linker);
        }
        for (Type type : this.nestedTypes) {
            type.link(linker);
        }
    }

    @Override
    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        for (Type type : this.nestedTypes) {
            type.linkOptions(linker);
        }
        for (Field field : this.declaredFields) {
            field.linkOptions(linker);
        }
        for (Field field : this.extensionFields) {
            field.linkOptions(linker);
        }
        for (OneOf oneOf : this.oneOfs) {
            oneOf.linkOptions(linker);
        }
        this.options.link(linker);
    }

    @Override
    Type retainAll(NavigableSet<String> identifiers) {
        ImmutableList.Builder retainedNestedTypesBuilder = ImmutableList.builder();
        for (Type nestedType : this.nestedTypes) {
            Type retainedNestedType = nestedType.retainAll(identifiers);
            if (retainedNestedType == null) continue;
            retainedNestedTypesBuilder.add((Object)retainedNestedType);
        }
        String typeName = this.protoType.toString();
        ImmutableList retainedNestedTypes = retainedNestedTypesBuilder.build();
        if (!identifiers.contains(typeName) && retainedNestedTypes.isEmpty()) {
            return null;
        }
        ImmutableList<Field> retainedFields = this.declaredFields;
        ImmutableList<Field> retainedExtensionFields = ImmutableList.copyOf(this.extensionFields);
        if (Pruner.hasMarkedMember(identifiers, this.protoType)) {
            retainedFields = this.retainFields(identifiers, (Collection<Field>)this.declaredFields);
            retainedExtensionFields = this.retainFields(identifiers, this.extensionFields);
        }
        return new MessageType(this.protoType, this.element, retainedFields, (List<Field>)retainedExtensionFields, this.oneOfs, (ImmutableList<Type>)retainedNestedTypes, this.extensionsList, this.options);
    }

    private ImmutableList<Field> retainFields(NavigableSet<String> identifiers, Collection<Field> fields) {
        ImmutableList.Builder retainedFieldsBuilder = ImmutableList.builder();
        for (Field field : fields) {
            if (!identifiers.contains(this.protoType + "#" + field.name())) continue;
            retainedFieldsBuilder.add((Object)field);
        }
        return retainedFieldsBuilder.build();
    }

    void addExtensionFields(ImmutableList<Field> fields) {
        this.extensionFields.addAll((Collection<Field>)fields);
    }
}

