/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.internal.protoparser.OptionElement;
import com.squareup.wire.internal.protoparser.RpcElement;
import com.squareup.wire.internal.protoparser.ServiceElement;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Type;
import java.util.List;
import java.util.Set;

public final class Service {
    private final Type.Name name;
    private final ServiceElement element;
    private final ImmutableList<Rpc> rpcs;
    private final Options options;

    private Service(Type.Name name, ServiceElement element, ImmutableList<Rpc> rpcs, Options options) {
        this.name = name;
        this.element = element;
        this.rpcs = rpcs;
        this.options = options;
    }

    public static Service get(Type.Name name, ServiceElement element) {
        ImmutableList.Builder rpcs = ImmutableList.builder();
        for (RpcElement rpc : element.rpcs()) {
            rpcs.add((Object)new Rpc(name.packageName(), rpc));
        }
        Options options = new Options(Type.Name.SERVICE_OPTIONS, name.packageName(), (List<OptionElement>)element.options());
        return new Service(name, element, (ImmutableList<Rpc>)rpcs.build(), options);
    }

    public Location location() {
        return this.element.location();
    }

    public Type.Name name() {
        return this.name;
    }

    public String documentation() {
        return this.element.documentation();
    }

    public ImmutableList<Rpc> rpcs() {
        return this.rpcs;
    }

    public Rpc rpc(String name) {
        for (Rpc rpc : this.rpcs) {
            if (!rpc.name().equals(name)) continue;
            return rpc;
        }
        return null;
    }

    public Options options() {
        return this.options;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.link(linker);
        }
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.linkOptions(linker);
        }
        this.options.link(linker);
    }

    Service retainAll(Set<String> identifiers) {
        String serviceName = this.name.toString();
        if (identifiers.contains(serviceName)) {
            return this;
        }
        ImmutableList.Builder retainedRpcsBuilde = ImmutableList.builder();
        for (Rpc rpc : this.rpcs) {
            if (!identifiers.contains(serviceName + '#' + rpc.name())) continue;
            retainedRpcsBuilde.add((Object)rpc);
        }
        ImmutableList retainedRpcs = retainedRpcsBuilde.build();
        if (!retainedRpcs.isEmpty()) {
            return new Service(this.name, this.element, (ImmutableList<Rpc>)retainedRpcs, this.options);
        }
        return null;
    }
}

