/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.ArrayList;
import java.util.List;

public abstract class Type {
    public abstract Location location();

    public abstract ProtoType name();

    public abstract String documentation();

    public abstract Options options();

    public abstract ImmutableList<Type> nestedTypes();

    abstract void link(Linker var1);

    abstract void linkOptions(Linker var1);

    abstract void validate(Linker var1);

    abstract Type retainAll(Schema var1, MarkSet var2);

    static Type get(String packageName, ProtoType protoType, TypeElement type) {
        if (type instanceof EnumElement) {
            EnumElement enumElement = (EnumElement)type;
            ImmutableList.Builder constants = ImmutableList.builder();
            for (EnumConstantElement constant : enumElement.constants()) {
                constants.add((Object)new EnumConstant(constant, new Options(Options.ENUM_VALUE_OPTIONS, (List<OptionElement>)constant.options())));
            }
            Options options = new Options(Options.ENUM_OPTIONS, (List<OptionElement>)enumElement.options());
            return new EnumType(protoType, enumElement, (ImmutableList<EnumConstant>)constants.build(), options);
        }
        if (type instanceof MessageElement) {
            MessageElement messageElement = (MessageElement)type;
            ImmutableList.Builder declaredFields = ImmutableList.builder();
            for (FieldElement field : messageElement.fields()) {
                declaredFields.add((Object)new Field(packageName, field, new Options(Options.FIELD_OPTIONS, (List<OptionElement>)field.options()), false));
            }
            ArrayList<Field> extensionFields = new ArrayList<Field>();
            ImmutableList.Builder oneOfs = ImmutableList.builder();
            for (OneOfElement oneOf : messageElement.oneOfs()) {
                ImmutableList.Builder fields = ImmutableList.builder();
                for (FieldElement field : oneOf.fields()) {
                    fields.add((Object)new Field(packageName, field, new Options(Options.FIELD_OPTIONS, (List<OptionElement>)field.options()), false));
                }
                oneOfs.add((Object)new OneOf(oneOf, (ImmutableList<Field>)fields.build()));
            }
            ImmutableList.Builder nestedTypes = ImmutableList.builder();
            for (TypeElement nestedType : messageElement.nestedTypes()) {
                nestedTypes.add((Object)Type.get(packageName, protoType.nestedType(nestedType.name()), nestedType));
            }
            ImmutableList.Builder extensionsList = ImmutableList.builder();
            for (ExtensionsElement element : messageElement.extensions()) {
                extensionsList.add((Object)new Extensions(element));
            }
            Options options = new Options(Options.MESSAGE_OPTIONS, (List<OptionElement>)messageElement.options());
            return new MessageType(protoType, messageElement, (ImmutableList<Field>)declaredFields.build(), extensionFields, (ImmutableList<OneOf>)oneOfs.build(), (ImmutableList<Type>)nestedTypes.build(), (ImmutableList<Extensions>)extensionsList.build(), options);
        }
        throw new IllegalArgumentException("unexpected type: " + type.getClass());
    }
}

