/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.wire.internal.Util;
import com.squareup.wire.internal.protoparser.EnumConstantElement;
import com.squareup.wire.internal.protoparser.EnumElement;
import com.squareup.wire.internal.protoparser.ExtensionsElement;
import com.squareup.wire.internal.protoparser.FieldElement;
import com.squareup.wire.internal.protoparser.MessageElement;
import com.squareup.wire.internal.protoparser.OneOfElement;
import com.squareup.wire.internal.protoparser.OptionElement;
import com.squareup.wire.internal.protoparser.TypeElement;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class Type {
    public abstract Location location();

    public abstract Name name();

    public abstract String documentation();

    public abstract Options options();

    public abstract ImmutableList<Type> nestedTypes();

    abstract void validate(Linker var1);

    abstract void link(Linker var1);

    abstract void linkOptions(Linker var1);

    abstract Type retainAll(Set<String> var1);

    static Type get(Name name, TypeElement type) {
        if (type instanceof EnumElement) {
            EnumElement enumElement = (EnumElement)type;
            ImmutableList.Builder constants = ImmutableList.builder();
            for (EnumConstantElement constant : enumElement.constants()) {
                constants.add((Object)new EnumConstant(name.packageName(), constant));
            }
            Options options = new Options(Name.ENUM_OPTIONS, name.packageName(), (List<OptionElement>)enumElement.options());
            return new EnumType(name, enumElement, (ImmutableList<EnumConstant>)constants.build(), options);
        }
        if (type instanceof MessageElement) {
            MessageElement messageElement = (MessageElement)type;
            String packageName = name.packageName();
            ImmutableList.Builder fields = ImmutableList.builder();
            for (FieldElement field : messageElement.fields()) {
                fields.add((Object)new Field(packageName, field));
            }
            ImmutableList.Builder oneOfs = ImmutableList.builder();
            for (OneOfElement oneOf : messageElement.oneOfs()) {
                oneOfs.add((Object)new OneOf(packageName, oneOf));
            }
            ImmutableList.Builder nestedTypes = ImmutableList.builder();
            for (TypeElement nestedType : messageElement.nestedTypes()) {
                nestedTypes.add((Object)Type.get(name.nestedType(nestedType.name()), nestedType));
            }
            ImmutableList.Builder extensionsList = ImmutableList.builder();
            for (ExtensionsElement element : messageElement.extensions()) {
                extensionsList.add((Object)new Extensions(element));
            }
            Options options = new Options(Name.MESSAGE_OPTIONS, name.packageName(), (List<OptionElement>)messageElement.options());
            return new MessageType(name, messageElement, (ImmutableList<Field>)fields.build(), (ImmutableList<OneOf>)oneOfs.build(), (ImmutableList<Type>)nestedTypes.build(), (ImmutableList<Extensions>)extensionsList.build(), options);
        }
        throw new IllegalArgumentException("unexpected type: " + type.getClass());
    }

    public static final class Name {
        public static final Name BOOL = new Name("bool");
        public static final Name BYTES = new Name("bytes");
        public static final Name DOUBLE = new Name("double");
        public static final Name FLOAT = new Name("float");
        public static final Name FIXED32 = new Name("fixed32");
        public static final Name FIXED64 = new Name("fixed64");
        public static final Name INT32 = new Name("int32");
        public static final Name INT64 = new Name("int64");
        public static final Name SFIXED32 = new Name("sfixed32");
        public static final Name SFIXED64 = new Name("sfixed64");
        public static final Name SINT32 = new Name("sint32");
        public static final Name SINT64 = new Name("sint64");
        public static final Name STRING = new Name("string");
        public static final Name UINT32 = new Name("uint32");
        public static final Name UINT64 = new Name("uint64");
        static final Name FILE_OPTIONS = Name.get("google.protobuf", "FileOptions");
        static final Name MESSAGE_OPTIONS = Name.get("google.protobuf", "MessageOptions");
        static final Name FIELD_OPTIONS = Name.get("google.protobuf", "FieldOptions");
        static final Name ENUM_OPTIONS = Name.get("google.protobuf", "EnumOptions");
        static final Name ENUM_VALUE_OPTIONS = Name.get("google.protobuf", "EnumValueOptions");
        static final Name SERVICE_OPTIONS = Name.get("google.protobuf", "ServiceOptions");
        static final Name METHOD_OPTIONS = Name.get("google.protobuf", "MethodOptions");
        private static final ImmutableMap<String, Name> SCALAR_TYPES = ImmutableMap.builder().put((Object)Name.BOOL.string, (Object)BOOL).put((Object)Name.BYTES.string, (Object)BYTES).put((Object)Name.DOUBLE.string, (Object)DOUBLE).put((Object)Name.FLOAT.string, (Object)FLOAT).put((Object)Name.FIXED32.string, (Object)FIXED32).put((Object)Name.FIXED64.string, (Object)FIXED64).put((Object)Name.INT32.string, (Object)INT32).put((Object)Name.INT64.string, (Object)INT64).put((Object)Name.SFIXED32.string, (Object)SFIXED32).put((Object)Name.SFIXED64.string, (Object)SFIXED64).put((Object)Name.SINT32.string, (Object)SINT32).put((Object)Name.SINT64.string, (Object)SINT64).put((Object)Name.STRING.string, (Object)STRING).put((Object)Name.UINT32.string, (Object)UINT32).put((Object)Name.UINT64.string, (Object)UINT64).build();
        private final String protoPackage;
        private final ImmutableList<String> names;
        private final boolean isScalar;
        private final String string;

        private Name(String scalarName) {
            this(null, (ImmutableList<String>)ImmutableList.of((Object)scalarName), true);
        }

        private Name(String protoPackage, ImmutableList<String> names, boolean isScalar) {
            this.protoPackage = protoPackage;
            this.names = names;
            this.isScalar = isScalar;
            this.string = (protoPackage != null ? protoPackage + '.' : "") + Joiner.on((char)'.').join(names);
        }

        public String packageName() {
            return this.protoPackage;
        }

        public String simpleName() {
            return (String)this.names.get(this.names.size() - 1);
        }

        public Name enclosingTypeName() {
            if (this.names.size() == 1) {
                return null;
            }
            return new Name(this.protoPackage, (ImmutableList<String>)this.names.subList(0, this.names.size() - 1), this.isScalar);
        }

        public boolean isScalar() {
            return this.isScalar;
        }

        public boolean isPackableScalar() {
            return this.isScalar && !this.equals(STRING) && !this.equals(BYTES);
        }

        public boolean isFieldOptions() {
            return this.equals(FIELD_OPTIONS);
        }

        public boolean isMessageOptions() {
            return this.equals(MESSAGE_OPTIONS);
        }

        public static Name get(String protoPackage, String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            return new Name(protoPackage, (ImmutableList<String>)ImmutableList.of((Object)name), false);
        }

        public static Name getScalar(String name) {
            return (Name)SCALAR_TYPES.get((Object)name);
        }

        public Name nestedType(String name) {
            Preconditions.checkState((!this.isScalar ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)name, (Object)"name");
            return new Name(this.protoPackage, Util.concatenate(this.names, name), false);
        }

        public boolean equals(Object o) {
            return o instanceof Name && Objects.equals(((Name)o).string, this.string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public String toString() {
            return this.string;
        }
    }
}

