/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.squareup.wire.internal.Util;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaException;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class Linker {
    private final ImmutableList<ProtoFile> protoFiles;
    private final Map<String, Type> protoTypeNames;
    private final Map<Type.Name, Map<String, Field>> extensionsMap;
    private final List<String> errors;
    private final List<Object> contextStack;

    public Linker(Iterable<ProtoFile> protoFiles) {
        this.protoFiles = ImmutableList.copyOf(protoFiles);
        this.protoTypeNames = new LinkedHashMap<String, Type>();
        this.extensionsMap = new LinkedHashMap<Type.Name, Map<String, Field>>();
        this.contextStack = Collections.emptyList();
        this.errors = new ArrayList<String>();
    }

    private Linker(Linker enclosing, Object additionalContext) {
        this.protoFiles = enclosing.protoFiles;
        this.protoTypeNames = enclosing.protoTypeNames;
        this.extensionsMap = enclosing.extensionsMap;
        this.contextStack = Util.concatenate(enclosing.contextStack, additionalContext);
        this.errors = enclosing.errors;
    }

    public Schema link() {
        for (ProtoFile protoFile : this.protoFiles) {
            for (Type type : protoFile.types()) {
                this.register(type);
            }
        }
        for (ProtoFile protoFile : this.protoFiles) {
            for (Extend extend : protoFile.extendList()) {
                extend.link(this);
            }
        }
        for (ProtoFile protoFile : this.protoFiles) {
            for (Extend extend : protoFile.extendList()) {
                Map<String, Field> map = this.extensionsMap.get(extend.type());
                if (map == null) {
                    map = new LinkedHashMap<String, Field>();
                    this.extensionsMap.put(extend.type(), map);
                }
                for (Field field : extend.fields()) {
                    map.put(extend.packageName() + "." + field.name(), field);
                }
            }
        }
        for (ProtoFile protoFile : this.protoFiles) {
            for (Type type : protoFile.types()) {
                type.link(this);
            }
            for (Service service : protoFile.services()) {
                service.link(this);
            }
        }
        for (ProtoFile protoFile : this.protoFiles) {
            protoFile.options().link(this);
            for (Type type : protoFile.types()) {
                type.linkOptions(this);
            }
            for (Service service : protoFile.services()) {
                service.linkOptions(this);
            }
        }
        for (ProtoFile protoFile : this.protoFiles) {
            for (Type type : protoFile.types()) {
                type.validate(this);
            }
            for (Extend extend : protoFile.extendList()) {
                extend.validate(this);
            }
        }
        if (!this.errors.isEmpty()) {
            throw new SchemaException(this.errors);
        }
        return new Schema((Iterable<ProtoFile>)this.protoFiles);
    }

    private void register(Type type) {
        this.protoTypeNames.put(type.name().toString(), type);
        for (Type nestedType : type.nestedTypes()) {
            this.register(nestedType);
        }
    }

    Type.Name resolveType(String packageName, String name) {
        return this.resolveType(packageName, name, false);
    }

    Type.Name resolveNamedType(String packageName, String name) {
        return this.resolveType(packageName, name, true);
    }

    private Type.Name resolveType(String packageName, String name, boolean namedTypesOnly) {
        Type samePackage;
        Type.Name scalar = Type.Name.getScalar(name);
        if (scalar != null) {
            if (namedTypesOnly) {
                this.addError("expected a message but was %s", name);
            }
            return scalar;
        }
        Type fullyQualified = this.protoTypeNames.get(name);
        if (fullyQualified != null) {
            return fullyQualified.name();
        }
        if (packageName != null && (samePackage = this.protoTypeNames.get(packageName + "." + name)) != null) {
            return samePackage.name();
        }
        for (int i = this.contextStack.size() - 1; i >= 0; --i) {
            Object context = this.contextStack.get(i);
            if (!(context instanceof Type)) continue;
            Type enclosingType = (Type)context;
            if (name.equals(enclosingType.name().simpleName())) {
                return enclosingType.name();
            }
            for (Type peerType : enclosingType.nestedTypes()) {
                if (!name.equals(peerType.name().simpleName())) continue;
                return peerType.name();
            }
        }
        this.addError("unable to resolve %s", name);
        return Type.Name.BYTES;
    }

    public Type get(Type.Name typeName) {
        return this.protoTypeNames.get(typeName.toString());
    }

    public Map<String, Field> extensions(Type.Name extensionType) {
        ImmutableMap result = this.extensionsMap.get(extensionType);
        return result != null ? result : ImmutableMap.of();
    }

    Field dereference(String packageName, Field self, String field) {
        Type type;
        if (field.startsWith("[") && field.endsWith("]")) {
            field = field.substring(1, field.length() - 1);
        }
        if ((type = this.protoTypeNames.get(self.type().toString())) instanceof MessageType) {
            Field messageField = ((MessageType)type).field(field);
            if (messageField != null) {
                return messageField;
            }
            Map<String, Field> typeExtensions = this.extensionsMap.get(self.type());
            Field extensionField = typeExtensions.get(field);
            if (extensionField != null) {
                return extensionField;
            }
            Field fullyQualifiedExtensionField = typeExtensions.get(packageName + "." + field);
            if (fullyQualifiedExtensionField != null) {
                return fullyQualifiedExtensionField;
            }
        }
        return null;
    }

    void validateTags(Iterable<Field> fields, Map<String, Field> extensionFields) {
        LinkedHashMultimap tagToField = LinkedHashMultimap.create();
        for (Field field : Iterables.concat(fields, extensionFields.values())) {
            int tag = field.tag();
            if (!Util.isValidTag(tag)) {
                this.withContext(field).addError("tag is out of range: %s", tag);
                continue;
            }
            tagToField.put((Object)tag, (Object)field);
        }
        for (Map.Entry entry : tagToField.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            StringBuilder error = new StringBuilder();
            error.append(String.format("multiple fields share tag %s:", entry.getKey()));
            int index = 1;
            for (Field field : (Collection)entry.getValue()) {
                error.append(String.format("\n  %s. %s (%s)", index++, field.name(), field.location()));
            }
            this.addError("%s", error);
        }
    }

    void validateEnumConstantNameUniqueness(Iterable<Type> nestedTypes) {
        LinkedHashMultimap nameToType = LinkedHashMultimap.create();
        for (Type type : nestedTypes) {
            if (!(type instanceof EnumType)) continue;
            EnumType enumType = (EnumType)type;
            for (EnumConstant enumConstant : enumType.constants()) {
                nameToType.put((Object)enumConstant.name(), (Object)enumType);
            }
        }
        for (Map.Entry entry : nameToType.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            StringBuilder error = new StringBuilder();
            String constant = (String)entry.getKey();
            int index = 1;
            error.append(String.format("multiple enums share constant %s:", constant));
            for (EnumType enumType : (Collection)entry.getValue()) {
                error.append(String.format("\n  %s. %s.%s (%s)", index++, enumType.name(), constant, enumType.constant(constant).location()));
            }
            this.addError("%s", error);
        }
    }

    Linker withContext(Object context) {
        return new Linker(this, context);
    }

    void addError(String format, Object ... args) {
        StringBuilder error = new StringBuilder();
        error.append(String.format(format, args));
        for (int i = this.contextStack.size() - 1; i >= 0; --i) {
            String prefix;
            Object context = this.contextStack.get(i);
            String string = prefix = i == this.contextStack.size() - 1 ? "\n  for" : "\n  in";
            if (context instanceof Rpc) {
                Rpc rpc = (Rpc)context;
                error.append(String.format("%s rpc %s (%s)", prefix, rpc.name(), rpc.location()));
                continue;
            }
            if (context instanceof Extend) {
                Extend extend = (Extend)context;
                Type.Name type = extend.type();
                error.append(type != null ? String.format("%s extend %s (%s)", prefix, type, extend.location()) : String.format("%s extend (%s)", prefix, extend.location()));
                continue;
            }
            if (context instanceof Field) {
                Field field = (Field)context;
                error.append(String.format("%s field %s (%s)", prefix, field.name(), field.location()));
                continue;
            }
            if (context instanceof MessageType) {
                MessageType message = (MessageType)context;
                error.append(String.format("%s message %s (%s)", prefix, message.name(), message.location()));
                continue;
            }
            if (context instanceof EnumType) {
                EnumType enumType = (EnumType)context;
                error.append(String.format("%s enum %s (%s)", prefix, enumType.name(), enumType.location()));
                continue;
            }
            if (context instanceof Service) {
                Service service = (Service)context;
                error.append(String.format("%s service %s (%s)", prefix, service.name(), service.location()));
                continue;
            }
            if (!(context instanceof Extensions)) continue;
            Extensions extensions = (Extensions)context;
            error.append(String.format("%s extensions (%s)", prefix, extensions.location()));
        }
        this.errors.add(error.toString());
    }
}

