/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.internal.protoparser.FieldElement;
import com.squareup.wire.internal.protoparser.OptionElement;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.Type;
import java.util.List;

public final class Field {
    private final String packageName;
    private final FieldElement element;
    private final Options options;
    private Type.Name type;

    Field(String packageName, FieldElement element) {
        this.packageName = packageName;
        this.element = element;
        this.options = new Options(Type.Name.FIELD_OPTIONS, packageName, (List<OptionElement>)element.options());
    }

    public Location location() {
        return this.element.location();
    }

    public String packageName() {
        return this.packageName;
    }

    public Label label() {
        return this.element.label();
    }

    public boolean isRepeated() {
        return this.label() == Label.REPEATED;
    }

    public boolean isOptional() {
        return this.label() == Label.OPTIONAL;
    }

    public boolean isRequired() {
        return this.label() == Label.REQUIRED;
    }

    public Type.Name type() {
        return this.type;
    }

    public String name() {
        return this.element.name();
    }

    public int tag() {
        return this.element.tag();
    }

    public String documentation() {
        return this.element.documentation();
    }

    public Options options() {
        return this.options;
    }

    public boolean isDeprecated() {
        return "true".equals(this.options().get("deprecated"));
    }

    public boolean isPacked() {
        return "true".equals(this.options().get("packed"));
    }

    public Object getDefault() {
        return this.options.get("default");
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.type = linker.resolveType(this.packageName, this.element.type());
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        this.options.link(linker);
    }

    public String toString() {
        return this.name();
    }

    void validate(Linker linker, boolean extension) {
        linker = linker.withContext(this);
        if (this.isPacked() && !this.isPackable(linker, this.type)) {
            linker.addError("packed=true not permitted on %s", this.type);
        }
        if (extension && this.isRequired()) {
            linker.addError("extension fields cannot be required", this.type);
        }
    }

    private boolean isPackable(Linker linker, Type.Name type) {
        return !type.equals(Type.Name.STRING) && !type.equals(Type.Name.BYTES) && !(linker.get(type) instanceof MessageType);
    }

    public static enum Label {
        OPTIONAL,
        REQUIRED,
        REPEATED,
        ONE_OF;

    }
}

