/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal.protoparser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.internal.Util;
import com.squareup.wire.internal.protoparser.AutoValue_OneOfElement;
import com.squareup.wire.internal.protoparser.FieldElement;

public abstract class OneOfElement {
    public static Builder builder() {
        return new AutoValue_OneOfElement.Builder().documentation("").fields((ImmutableList<FieldElement>)ImmutableList.of());
    }

    public abstract String name();

    public abstract String documentation();

    public abstract ImmutableList<FieldElement> fields();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append("oneof ").append(this.name()).append(" {");
        if (!this.fields().isEmpty()) {
            builder.append('\n');
            for (FieldElement field : this.fields()) {
                Util.appendIndented(builder, field.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder documentation(String var1);

        public Builder fields(ImmutableList<FieldElement> var1);

        public OneOfElement build();
    }
}

