/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.FileLinker;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.internal.DagChecker;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0002J\u0016\u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/squareup/wire/schema/CycleChecker;", "", "fileLinkers", "", "", "Lcom/squareup/wire/schema/FileLinker;", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "(Ljava/util/Map;Lcom/squareup/wire/schema/ErrorCollector;)V", "goPackageOption", "Lcom/squareup/wire/schema/ProtoMember;", "cycleCheckPackageName", "getCycleCheckPackageName", "(Lcom/squareup/wire/schema/FileLinker;)Ljava/lang/String;", "importsAndPublicImports", "", "getImportsAndPublicImports", "(Lcom/squareup/wire/schema/FileLinker;)Ljava/util/List;", "checkForImportCycles", "", "checkForPackageCycles", "importCycleMessageError", "files", "packagesCycleMessageError", "packages", "wire-schema"})
@SourceDebugExtension(value={"SMAP\nCycleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CycleChecker.kt\ncom/squareup/wire/schema/CycleChecker\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n372#2,7:165\n1045#3:172\n*S KotlinDebug\n*F\n+ 1 CycleChecker.kt\ncom/squareup/wire/schema/CycleChecker\n*L\n93#1:165,7\n131#1:172\n*E\n"})
public final class CycleChecker {
    @NotNull
    private final Map<String, FileLinker> fileLinkers;
    @NotNull
    private final ErrorCollector errors;
    @NotNull
    private final ProtoMember goPackageOption;

    public CycleChecker(@NotNull Map<String, FileLinker> fileLinkers, @NotNull ErrorCollector errors) {
        Intrinsics.checkNotNullParameter(fileLinkers, (String)"fileLinkers");
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        this.fileLinkers = fileLinkers;
        this.errors = errors;
        this.goPackageOption = ProtoMember.Companion.get("google.protobuf.FileOptions#go_package");
    }

    private final List<String> getImportsAndPublicImports(FileLinker $this$importsAndPublicImports) {
        return CollectionsKt.plus((Collection)$this$importsAndPublicImports.getProtoFile().getImports(), (Iterable)$this$importsAndPublicImports.getProtoFile().getPublicImports());
    }

    private final String getCycleCheckPackageName(FileLinker $this$cycleCheckPackageName) {
        String goPackage;
        Object object = $this$cycleCheckPackageName.getProtoFile().getOptions().get(this.goPackageOption);
        String string = goPackage = object instanceof String ? (String)object : null;
        if (goPackage != null) {
            return goPackage;
        }
        String string2 = $this$cycleCheckPackageName.getProtoFile().getPackageName();
        if (string2 == null) {
            string2 = "<default>";
        }
        return string2;
    }

    public final void checkForImportCycles() {
        DagChecker dagChecker2 = new DagChecker((Iterable)this.fileLinkers.keySet(), (Function1)new Function1<String, Iterable<? extends String>>(this){
            final /* synthetic */ CycleChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Iterable<String> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FileLinker fileLinker = (FileLinker)CycleChecker.access$getFileLinkers$p(this.this$0).get(it);
                if (fileLinker == null) {
                    return CollectionsKt.emptyList();
                }
                FileLinker fileLinker2 = fileLinker;
                return CollectionsKt.plus((Collection)fileLinker2.getProtoFile().getImports(), (Iterable)fileLinker2.getProtoFile().getPublicImports());
            }
        });
        Set cycles = dagChecker2.check();
        for (List<String> list : cycles) {
            this.errors.plusAssign(this.importCycleMessageError(list));
        }
    }

    private final String importCycleMessageError(List<String> files) {
        StringBuilder stringBuilder;
        StringBuilder $this$importCycleMessageError_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$importCycleMessageError_u24lambda_u240.append("imports form a cycle:");
        for (String file : files) {
            FileLinker fileLinker;
            if (this.fileLinkers.get(file) == null) continue;
            $this$importCycleMessageError_u24lambda_u240.append("\n  " + file + ':');
            for (String string : fileLinker.getProtoFile().getImports()) {
                if (!files.contains(string)) continue;
                $this$importCycleMessageError_u24lambda_u240.append("\n    import \"" + string + "\";");
            }
            for (String string : fileLinker.getProtoFile().getPublicImports()) {
                if (!files.contains(string)) continue;
                $this$importCycleMessageError_u24lambda_u240.append("\n    import public \"" + string + "\";");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final void checkForPackageCycles() {
        Map packageDag = new LinkedHashMap();
        for (FileLinker fileLinker : this.fileLinkers.values()) {
            Object object;
            Map map = packageDag;
            String key$iv = this.getCycleCheckPackageName(fileLinker);
            boolean $i$f$getOrPut = false;
            Object value$iv = map.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                map.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set targets = (Set)object;
            for (String path : this.getImportsAndPublicImports(fileLinker)) {
                FileLinker imported;
                if (this.fileLinkers.get(path) == null) continue;
                ((Collection)targets).add(this.getCycleCheckPackageName(imported));
            }
            targets.remove(this.getCycleCheckPackageName(fileLinker));
        }
        DagChecker dagChecker2 = new DagChecker(packageDag.keySet(), (Function1)new Function1<String, Iterable<? extends String>>((Map<String, Set<String>>)packageDag){
            final /* synthetic */ Map<String, Set<String>> $packageDag;
            {
                this.$packageDag = $packageDag;
                super(1);
            }

            @NotNull
            public final Iterable<String> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Set<String> set = this.$packageDag.get(it);
                Intrinsics.checkNotNull(set);
                return set;
            }
        });
        Set cycles = dagChecker2.check();
        for (List<String> list : cycles) {
            this.errors.plusAssign(this.packagesCycleMessageError(list));
        }
    }

    private final String packagesCycleMessageError(List<String> packages) {
        StringBuilder stringBuilder;
        StringBuilder $this$packagesCycleMessageError_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$packagesCycleMessageError_u24lambda_u243.append("packages form a cycle:");
        Iterable $this$sortedBy$iv = this.fileLinkers.entrySet();
        boolean $i$f$sortedBy = false;
        List sortedFileLinkers = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
            final /* synthetic */ CycleChecker this$0;
            {
                this.this$0 = cycleChecker;
            }

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)CycleChecker.access$getCycleCheckPackageName(this.this$0, (FileLinker)it.getValue()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)CycleChecker.access$getCycleCheckPackageName(this.this$0, (FileLinker)it.getValue()))));
            }
        });
        String lastSourcePackage = null;
        String lastTargetPackage = null;
        String lastSourcePath = null;
        for (Map.Entry entry : sortedFileLinkers) {
            String sourcePath = (String)entry.getKey();
            FileLinker sourceFileLinker = (FileLinker)entry.getValue();
            String sourcePackage = this.getCycleCheckPackageName(sourceFileLinker);
            if (!packages.contains(sourcePackage)) continue;
            for (String targetPath : this.getImportsAndPublicImports(sourceFileLinker)) {
                FileLinker targetFileLinker;
                String targetPackage;
                if (this.fileLinkers.get(targetPath) == null || Intrinsics.areEqual((Object)(targetPackage = this.getCycleCheckPackageName(targetFileLinker)), (Object)sourcePackage) || !packages.contains(targetPackage)) continue;
                if (!Intrinsics.areEqual(lastSourcePackage, (Object)sourcePackage) || !Intrinsics.areEqual(lastTargetPackage, (Object)targetPackage)) {
                    $this$packagesCycleMessageError_u24lambda_u243.append("\n  " + sourcePackage + " imports " + targetPackage);
                    lastSourcePackage = sourcePackage;
                    lastTargetPackage = targetPackage;
                    lastSourcePath = null;
                }
                if (!Intrinsics.areEqual(lastSourcePath, (Object)sourcePath)) {
                    $this$packagesCycleMessageError_u24lambda_u243.append("\n    " + sourcePath + ':');
                    lastSourcePath = sourcePath;
                }
                $this$packagesCycleMessageError_u24lambda_u243.append("\n      import \"" + targetPath + "\";");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final /* synthetic */ Map access$getFileLinkers$p(CycleChecker $this) {
        return $this.fileLinkers;
    }

    public static final /* synthetic */ String access$getCycleCheckPackageName(CycleChecker $this, FileLinker $receiver) {
        return $this.getCycleCheckPackageName($receiver);
    }
}

